/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateVerify
extends HandshakeMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateVerify.class.getCanonicalName());
    private static final int HASH_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_LENGTH_BITS = 16;
    private byte[] signatureBytes;
    private final SignatureAndHashAlgorithm signatureAndHashAlgorithm;

    public CertificateVerify(SignatureAndHashAlgorithm signatureAndHashAlgorithm, PrivateKey clientPrivateKey, byte[] handshakeMessages, InetSocketAddress peerAddress) {
        this(signatureAndHashAlgorithm, peerAddress);
        this.signatureBytes = this.setSignature(clientPrivateKey, handshakeMessages);
    }

    private CertificateVerify(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] signatureBytes, InetSocketAddress peerAddress) {
        this(signatureAndHashAlgorithm, peerAddress);
        this.signatureBytes = Arrays.copyOf(signatureBytes, signatureBytes.length);
    }

    private CertificateVerify(SignatureAndHashAlgorithm signatureAndHashAlgorithm, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CERTIFICATE_VERIFY;
    }

    @Override
    public int getMessageLength() {
        return 4 + this.signatureBytes.length;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.signatureAndHashAlgorithm.getHash().getCode(), 8);
        writer.write(this.signatureAndHashAlgorithm.getSignature().getCode(), 8);
        writer.write(this.signatureBytes.length, 16);
        writer.writeBytes(this.signatureBytes);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        DatagramReader reader = new DatagramReader(byteArray);
        int hashAlgorithm = reader.read(8);
        int signatureAlgorithm = reader.read(8);
        SignatureAndHashAlgorithm signAndHash = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
        int length = reader.read(16);
        byte[] signature = reader.readBytes(length);
        return new CertificateVerify(signAndHash, signature, peerAddress);
    }

    private byte[] setSignature(PrivateKey clientPrivateKey, byte[] handshakeMessages) {
        this.signatureBytes = Bytes.EMPTY;
        try {
            Signature signature = Signature.getInstance(this.signatureAndHashAlgorithm.jcaName());
            signature.initSign(clientPrivateKey);
            signature.update(handshakeMessages);
            this.signatureBytes = signature.sign();
        }
        catch (Exception e) {
            LOGGER.error("Could not create signature.", e);
        }
        return this.signatureBytes;
    }

    public void verifySignature(PublicKey clientPublicKey, byte[] handshakeMessages) throws HandshakeException {
        boolean verified = false;
        try {
            Signature signature = Signature.getInstance(this.signatureAndHashAlgorithm.jcaName());
            signature.initVerify(clientPublicKey);
            signature.update(handshakeMessages);
            verified = signature.verify(this.signatureBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            LOGGER.error("Could not verify the client's signature.", e);
        }
        if (!verified) {
            String message = "The client's CertificateVerify message could not be verified.";
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeer());
            throw new HandshakeException(message, alert);
        }
    }
}

