/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import org.eclipse.californium.elements.util.StringUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void testHex2ByteArray() {
        String line = "4130010A";
        byte[] result = StringUtil.hex2ByteArray(line);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)new byte[]{65, 48, 1, 10}));
    }

    @Test
    public void testHex2CharArray() {
        String line = "4130010A";
        char[] result = StringUtil.hex2CharArray(line);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)new char[]{'A', '0', '\u0001', '\n'}));
    }

    @Test
    public void testHex2CharArrayWithNull() {
        String line = null;
        char[] result = StringUtil.hex2CharArray(line);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHex2CharArrayIllegalArgumentLength() {
        String line = "4130010A0";
        StringUtil.hex2CharArray(line);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHex2CharArrayIllegalArgumentContent() {
        String line = "4130010A0Z";
        StringUtil.hex2CharArray(line);
    }
}

