/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatagramReaderTest {
    DatagramReader reader;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testBitsLeftWorksForEmptyBuffer() {
        this.givenABuffer(Bytes.EMPTY);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testBitsLeftWorksForByteWiseReading() {
        this.givenABuffer(new byte[]{1, 2, 3});
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)24));
        this.reader.readBytes(1);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)16));
        this.reader.readBytes(1);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)8));
        this.reader.readBytes(1);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testBitsLeftWorksForBitWiseReading() {
        this.givenABuffer(new byte[]{1, 2, 3});
        this.reader.read(6);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)18));
        this.reader.readBytes(1);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)10));
        this.reader.read(10);
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testMarkAndResetBits() {
        this.givenABuffer(new byte[]{1, 2, 3});
        int value = this.reader.read(6);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)18));
        this.reader.mark();
        value = this.reader.readBytes(1)[0] & 0xFF;
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)64));
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)10));
        this.reader.reset();
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)18));
        value = this.reader.readBytes(1)[0] & 0xFF;
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)64));
        Assert.assertThat((Object)this.reader.bitsLeft(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testMarkAndResetBytes() {
        this.givenABuffer(new byte[]{1, 2, 3, 4, 5, 6});
        int value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)1));
        value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)2));
        this.reader.mark();
        value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)3));
        value = this.reader.read(8);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)4));
        this.reader.reset();
        byte[] bytes = this.reader.readBytes(4);
        Assert.assertThat((Object)bytes, (Matcher)CoreMatchers.is((Object)new byte[]{3, 4, 5, 6}));
    }

    private void givenABuffer(byte[] buffer) {
        this.reader = new DatagramReader(buffer);
    }
}

