/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import java.io.ByteArrayInputStream;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.CoAPMessageFormatException;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.serialization.MessageHeader;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.util.DatagramReader;

public abstract class DataParser {
    public final Message parseMessage(RawData raw) {
        if (raw == null) {
            throw new NullPointerException("raw-data must not be null!");
        }
        Message message = this.parseMessage(raw.getBytes());
        message.setSourceContext(raw.getEndpointContext());
        return message;
    }

    public final Message parseMessage(byte[] msg) {
        String errorMsg = "illegal message code";
        DatagramReader reader = new DatagramReader(new ByteArrayInputStream(msg));
        MessageHeader header = this.parseHeader(reader);
        try {
            Message message = null;
            if (CoAP.isRequest(header.getCode())) {
                message = DataParser.parseMessage(reader, header, new Request(CoAP.Code.valueOf(header.getCode())));
            } else if (CoAP.isResponse(header.getCode())) {
                message = DataParser.parseMessage(reader, header, new Response(CoAP.ResponseCode.valueOf(header.getCode())));
            } else if (CoAP.isEmptyMessage(header.getCode())) {
                message = DataParser.parseMessage(reader, header, new EmptyMessage(header.getType()));
            }
            if (message != null) {
                message.setBytes(msg);
                return message;
            }
        }
        catch (MessageFormatException e) {
            errorMsg = e.getMessage();
        }
        throw new CoAPMessageFormatException(errorMsg, header.getMID(), header.getCode(), CoAP.Type.CON == header.getType());
    }

    private static Message parseMessage(DatagramReader source, MessageHeader header, Message target) {
        target.setMID(header.getMID());
        target.setType(header.getType());
        target.setToken(header.getToken());
        DataParser.parseOptionsAndPayload(source, target);
        return target;
    }

    protected abstract MessageHeader parseHeader(DatagramReader var1);

    protected static final void assertValidTokenLength(int tokenLength) {
        if (tokenLength > 8) {
            throw new MessageFormatException("Message has invalid token length (> 8)" + tokenLength);
        }
    }

    public static void parseOptionsAndPayload(DatagramReader reader, Message message) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null!");
        }
        if (message == null) {
            throw new NullPointerException("message must not be null!");
        }
        int currentOptionNumber = 0;
        byte nextByte = 0;
        while (reader.bytesAvailable() && (nextByte = reader.readNextByte()) != -1) {
            int optionDeltaNibble = (0xF0 & nextByte) >> 4;
            currentOptionNumber = DataParser.calculateNextOptionNumber(reader, currentOptionNumber, optionDeltaNibble, message);
            int optionLengthNibble = 0xF & nextByte;
            int optionLength = DataParser.determineValueFromNibble(reader, optionLengthNibble, message);
            if (reader.bytesAvailable(optionLength)) {
                Option option = new Option(currentOptionNumber);
                option.setValue(reader.readBytes(optionLength));
                message.getOptions().addOption(option);
                continue;
            }
            String msg = String.format("Message contains option of length %d with only fewer bytes left in the message", optionLength);
            throw new CoAPMessageFormatException(msg, message.getMID(), message.getRawCode(), message.isConfirmable());
        }
        if (nextByte == -1) {
            if (!reader.bytesAvailable()) {
                throw new CoAPMessageFormatException("Found payload marker (0xFF) but message contains no payload", message.getMID(), message.getRawCode(), message.isConfirmable());
            }
            if (!message.isIntendedPayload()) {
                message.setUnintendedPayload();
            }
            message.setPayload(reader.readBytesLeft());
        } else {
            message.setPayload((String)null);
        }
    }

    private static int calculateNextOptionNumber(DatagramReader reader, int currentOptionNumber, int delta, Message message) {
        return currentOptionNumber + DataParser.determineValueFromNibble(reader, delta, message);
    }

    private static int determineValueFromNibble(DatagramReader reader, int delta, Message message) {
        if (delta <= 12) {
            return delta;
        }
        if (delta == 13) {
            return reader.read(8) + 13;
        }
        if (delta == 14) {
            return reader.read(16) + 269;
        }
        throw new CoAPMessageFormatException("Message contains illegal option delta/length: " + delta, message.getMID(), message.getRawCode(), message.isConfirmable());
    }
}

