/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;

public class DefaultTest
extends CoapResource {
    public DefaultTest() {
        super("test");
        this.getAttributes().setTitle("Default test resource");
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        StringBuilder payload = new StringBuilder();
        Request request = exchange.advanced().getRequest();
        payload.append(String.format("Type: %d (%s)\nCode: %d (%s)\nMID: %d", new Object[]{request.getType().value, request.getType(), request.getCode().value, request.getCode(), request.getMID()}));
        if (request.getToken().length > 0) {
            payload.append("\nToken: ");
            StringBuffer tok = new StringBuffer(request.getToken() == null ? "null" : "");
            if (request.getToken() != null) {
                for (byte b : request.getToken()) {
                    tok.append(String.format("%02x", b & 0xFF));
                }
            }
            payload.append(tok);
        }
        if (payload.length() > 64) {
            payload.delete(62, payload.length());
            payload.append('\u00bb');
        }
        exchange.setMaxAge(30L);
        exchange.respond(CoAP.ResponseCode.CONTENT, payload.toString(), 0);
    }

    @Override
    public void handlePOST(CoapExchange exchange) {
        exchange.setLocationPath("/location1/location2/location3");
        exchange.respond(CoAP.ResponseCode.CREATED);
    }

    @Override
    public void handlePUT(CoapExchange exchange) {
        if (exchange.getRequestOptions().hasIfNoneMatch()) {
            exchange.respond(CoAP.ResponseCode.PRECONDITION_FAILED);
        } else {
            exchange.respond(CoAP.ResponseCode.CHANGED);
        }
    }

    @Override
    public void handleDELETE(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.DELETED);
    }
}

