/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.network.stack.BlockwiseLayer;
import org.eclipse.californium.core.network.stack.Layer;
import org.eclipse.californium.core.network.stack.ObserveLayer;
import org.eclipse.californium.core.network.stack.ReliabilityLayer;
import org.eclipse.californium.core.network.stack.TokenLayer;
import org.eclipse.californium.core.server.MessageDeliverer;

public class CoapStack {
    static final Logger LOGGER = Logger.getLogger(CoapStack.class.getCanonicalName());
    private List<Layer> layers;
    private Outbox outbox;
    private StackTopAdapter top = new StackTopAdapter();
    private StackBottomAdapter bottom;
    private MessageDeliverer deliverer;

    public CoapStack(NetworkConfig config, Outbox outbox) {
        this.outbox = outbox;
        this.bottom = new StackBottomAdapter();
        this.layers = new Layer.TopDownBuilder().add(this.top).add(new ObserveLayer(config)).add(new BlockwiseLayer(config)).add(new TokenLayer(config)).add(new ReliabilityLayer(config)).add(this.bottom).create();
        this.deliverer = new EndpointManager.ClientMessageDeliverer();
    }

    public void sendRequest(Request request) {
        this.top.sendRequest(request);
    }

    public void sendResponse(Exchange exchange, Response response) {
        this.top.sendResponse(exchange, response);
    }

    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.top.sendEmptyMessage(exchange, message);
    }

    public void receiveRequest(Exchange exchange, Request request) {
        this.bottom.receiveRequest(exchange, request);
    }

    public void receiveResponse(Exchange exchange, Response response) {
        this.bottom.receiveResponse(exchange, response);
    }

    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.bottom.receiveEmptyMessage(exchange, message);
    }

    public void setExecutor(ScheduledExecutorService executor) {
        for (Layer layer : this.layers) {
            layer.setExecutor(executor);
        }
    }

    public void setDeliverer(MessageDeliverer deliverer) {
        this.deliverer = deliverer;
    }

    public boolean hasDeliverer() {
        return this.deliverer != null;
    }

    private class StackBottomAdapter
    extends AbstractLayer {
        private StackBottomAdapter() {
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            CoapStack.this.outbox.sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            CoapStack.this.outbox.sendResponse(exchange, response);
        }

        @Override
        public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
            CoapStack.this.outbox.sendEmptyMessage(exchange, message);
        }
    }

    private class StackTopAdapter
    extends AbstractLayer {
        private StackTopAdapter() {
        }

        public void sendRequest(Request request) {
            Exchange exchange = new Exchange(request, Exchange.Origin.LOCAL);
            this.sendRequest(exchange, request);
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            exchange.setRequest(request);
            super.sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            exchange.setResponse(response);
            super.sendResponse(exchange, response);
        }

        @Override
        public void receiveRequest(Exchange exchange, Request request) {
            if (exchange.getRequest() == null) {
                exchange.setRequest(request);
            }
            if (CoapStack.this.deliverer != null) {
                CoapStack.this.deliverer.deliverRequest(exchange);
            } else {
                LOGGER.severe("Top of CoAP stack has no deliverer to deliver request");
            }
        }

        @Override
        public void receiveResponse(Exchange exchange, Response response) {
            if (!response.getOptions().hasObserve()) {
                exchange.setComplete();
            }
            if (CoapStack.this.deliverer != null) {
                CoapStack.this.deliverer.deliverResponse(exchange, response);
            } else {
                LOGGER.severe("Top of CoAP stack has no deliverer to deliver response");
            }
        }

        @Override
        public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        }
    }
}

