/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.CoAPEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointObserver;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.MessageDeliverer;

public class EndpointManager {
    private static final Logger LOGGER = Logger.getLogger(EndpointManager.class.getCanonicalName());
    public static final int DEFAULT_COAP_PORT = 5683;
    public static final int DEFAULT_COAP_SECURE_PORT = 5684;
    private static EndpointManager manager = new EndpointManager();
    private Endpoint default_endpoint;
    private Endpoint default_dtls_endpoint;

    public static EndpointManager getEndpointManager() {
        return manager;
    }

    public Endpoint getDefaultEndpoint() {
        try {
            if (this.default_endpoint == null) {
                this.createDefaultEndpoint();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while getting the default endpoint", e);
        }
        return this.default_endpoint;
    }

    private synchronized void createDefaultEndpoint() throws UnknownHostException {
        if (this.default_endpoint != null) {
            return;
        }
        int threadCount = NetworkConfig.getStandard().getInt("DEFAULT_ENDPOINT_THREAD_COUNT");
        final ScheduledExecutorService executor = Executors.newScheduledThreadPool(threadCount, new DaemonThreadFactory());
        InetAddress localhost = null;
        int port = 0;
        InetSocketAddress address = new InetSocketAddress(localhost, port);
        this.default_endpoint = new CoAPEndpoint(address);
        this.default_endpoint.setMessageDeliverer(new ClientMessageDeliverer());
        this.default_endpoint.setExecutor(executor);
        this.default_endpoint.addObserver(new EndpointObserver(){

            @Override
            public void started(Endpoint endpoint) {
            }

            @Override
            public void stopped(Endpoint endpoint) {
            }

            @Override
            public void destroyed(Endpoint endpoint) {
                executor.shutdown();
            }
        });
        try {
            this.default_endpoint.start();
            LOGGER.log(Level.INFO, "Created default endpoint " + this.default_endpoint.getAddress());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not create default endpoint", e);
        }
    }

    public void setDefaultEndpoint(Endpoint endpoint) {
        this.default_endpoint = endpoint;
    }

    public Endpoint getDefaultSecureEndpoint() {
        try {
            if (this.default_dtls_endpoint == null) {
                this.createDefaultSecureEndpoint();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while getting the default secure endpoint", e);
        }
        return this.default_dtls_endpoint;
    }

    private synchronized void createDefaultSecureEndpoint() {
        if (this.default_dtls_endpoint != null) {
            return;
        }
        LOGGER.severe("Secure endpoint must be injected via setDefaultSecureEndpoint()");
    }

    public void setDefaultSecureEndpoint(Endpoint endpoint) {
        this.default_dtls_endpoint = endpoint;
    }

    public Collection<InetAddress> getNetworkInterfaces() {
        LinkedList<InetAddress> interfaces = new LinkedList<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                if (!inetAddresses.hasMoreElements()) continue;
                interfaces.add(inetAddresses.nextElement());
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return interfaces;
    }

    public static void clear() {
        EndpointManager it = EndpointManager.getEndpointManager();
        if (it.default_endpoint != null) {
            it.default_endpoint.clear();
        }
        if (it.default_dtls_endpoint != null) {
            it.default_dtls_endpoint.clear();
        }
    }

    public static class DaemonThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static class ClientMessageDeliverer
    implements MessageDeliverer {
        @Override
        public void deliverRequest(Exchange exchange) {
            LOGGER.severe("Default endpoint has received a request. What should happen now?");
            exchange.sendReject();
        }

        @Override
        public void deliverResponse(Exchange exchange, Response response) {
            if (exchange == null) {
                throw new NullPointerException();
            }
            if (exchange.getRequest() == null) {
                throw new NullPointerException();
            }
            if (response == null) {
                throw new NullPointerException();
            }
            LOGGER.fine("Deliver response to request");
            exchange.getRequest().setResponse(response);
        }
    }
}

