/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.Option;

public class OptionSet {
    private List<byte[]> if_match_list;
    private String uri_host;
    private List<byte[]> etag_list;
    private boolean if_none_match;
    private Integer uri_port;
    private List<String> location_path_list;
    private List<String> uri_path_list;
    private Integer content_format;
    private Long max_age;
    private List<String> uri_query_list;
    private Integer accept;
    private List<String> location_query_list;
    private String proxy_uri;
    private String proxy_scheme;
    private BlockOption block1;
    private BlockOption block2;
    private Integer observe;
    private List<Option> others;

    public OptionSet() {
        this.if_match_list = null;
        this.uri_host = null;
        this.etag_list = null;
        this.if_none_match = false;
        this.uri_port = null;
        this.location_path_list = null;
        this.uri_path_list = null;
        this.content_format = null;
        this.max_age = null;
        this.uri_query_list = null;
        this.accept = null;
        this.location_query_list = null;
        this.proxy_uri = null;
        this.proxy_scheme = null;
        this.block1 = null;
        this.block2 = null;
        this.observe = null;
        this.others = null;
    }

    public void clear() {
        if (this.if_match_list != null) {
            this.if_match_list.clear();
        }
        this.uri_host = null;
        if (this.etag_list != null) {
            this.etag_list.clear();
        }
        this.if_none_match = false;
        this.uri_port = null;
        if (this.location_path_list != null) {
            this.location_path_list.clear();
        }
        if (this.uri_path_list != null) {
            this.uri_path_list.clear();
        }
        this.content_format = null;
        this.max_age = null;
        if (this.uri_query_list != null) {
            this.uri_query_list.clear();
        }
        this.accept = null;
        if (this.location_query_list != null) {
            this.location_path_list.clear();
        }
        this.proxy_uri = null;
        this.proxy_scheme = null;
        this.block1 = null;
        this.block2 = null;
        this.observe = null;
        if (this.others != null) {
            this.others.clear();
        }
    }

    public OptionSet(OptionSet origin) {
        if (origin == null) {
            throw new NullPointerException();
        }
        this.if_match_list = this.copyList(origin.if_match_list);
        this.uri_host = origin.uri_host;
        this.etag_list = this.copyList(origin.etag_list);
        this.if_none_match = origin.if_none_match;
        this.uri_port = origin.uri_port;
        this.location_path_list = this.copyList(origin.location_path_list);
        this.uri_path_list = this.copyList(origin.uri_path_list);
        this.content_format = origin.content_format;
        this.max_age = origin.max_age;
        this.uri_query_list = this.copyList(origin.uri_query_list);
        this.accept = origin.accept;
        this.location_query_list = this.copyList(origin.location_query_list);
        this.proxy_uri = origin.proxy_uri;
        this.proxy_scheme = origin.proxy_scheme;
        if (origin.block1 != null) {
            this.block1 = new BlockOption(origin.block1);
        }
        if (origin.block2 != null) {
            this.block2 = new BlockOption(origin.block2);
        }
        this.observe = origin.observe;
        this.others = this.copyList(origin.others);
    }

    private <T> List<T> copyList(List<T> list) {
        if (list == null) {
            return null;
        }
        return new LinkedList<T>(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getIfMatch() {
        if (this.if_match_list == null) {
            OptionSet optionSet = this;
            synchronized (optionSet) {
                if (this.if_match_list == null) {
                    this.if_match_list = new LinkedList<byte[]>();
                }
            }
        }
        return this.if_match_list;
    }

    public int getIfMatchCount() {
        return this.getIfMatch().size();
    }

    public boolean isIfMatch(byte[] what) {
        if (this.if_match_list == null) {
            return true;
        }
        for (byte[] etag : this.if_match_list) {
            if (!Arrays.equals(etag, what)) continue;
            return true;
        }
        return false;
    }

    public OptionSet addIfMatch(byte[] opaque) {
        if (opaque == null) {
            throw new IllegalArgumentException("If-Match option must not be null");
        }
        if (opaque.length > 8) {
            throw new IllegalArgumentException("Content of If-Match option is too large: " + Utils.toHexString(opaque));
        }
        this.getIfMatch().add(opaque);
        return this;
    }

    public OptionSet removeIfMatch(byte[] opaque) {
        this.getIfMatch().remove(opaque);
        return this;
    }

    public OptionSet clearIfMatchs() {
        this.getIfMatch().clear();
        return this;
    }

    public String getURIHost() {
        return this.uri_host;
    }

    public boolean hasURIHost() {
        return this.uri_host != null;
    }

    public OptionSet setURIHost(String host) {
        if (host == null) {
            throw new NullPointerException("URI-Host must not be null");
        }
        if (host.length() < 1 || 255 < host.length()) {
            throw new IllegalArgumentException("URI-Host option's length must be between 1 and 255 inclusive");
        }
        this.uri_host = host;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getETags() {
        if (this.etag_list == null) {
            OptionSet optionSet = this;
            synchronized (optionSet) {
                if (this.etag_list == null) {
                    this.etag_list = new LinkedList<byte[]>();
                }
            }
        }
        return this.etag_list;
    }

    public int getETagCount() {
        return this.getETags().size();
    }

    public boolean containsETag(byte[] what) {
        if (this.etag_list == null) {
            return false;
        }
        for (byte[] etag : this.etag_list) {
            if (!Arrays.equals(etag, what)) continue;
            return true;
        }
        return false;
    }

    public OptionSet addETag(byte[] opaque) {
        if (opaque == null) {
            throw new IllegalArgumentException("ETag option must not be null");
        }
        this.getETags().add(opaque);
        return this;
    }

    public OptionSet removeETag(byte[] opaque) {
        this.getETags().remove(opaque);
        return this;
    }

    public OptionSet clearETags() {
        this.getETags().clear();
        return this;
    }

    public boolean hasIfNoneMatch() {
        return this.if_none_match;
    }

    public OptionSet setIfNoneMatch(boolean b) {
        this.if_none_match = b;
        return this;
    }

    public Integer getURIPort() {
        return this.uri_port;
    }

    public boolean hasURIPort() {
        return this.uri_port != null;
    }

    public OptionSet setURIPort(int port) {
        if (port < 0 || 65535 < port) {
            throw new IllegalArgumentException("URI port option must be between 0 and 65535 (2 bytes) inclusive but was " + port);
        }
        this.uri_port = port;
        return this;
    }

    public OptionSet removeURIPort() {
        this.uri_port = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLocationPaths() {
        if (this.location_path_list == null) {
            OptionSet optionSet = this;
            synchronized (optionSet) {
                if (this.location_path_list == null) {
                    this.location_path_list = new LinkedList<String>();
                }
            }
        }
        return this.location_path_list;
    }

    public String getLocationString() {
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        builder.append(this.getLocationPathString());
        if (this.getLocationQueryCount() > 0) {
            builder.append("?");
            builder.append(this.getLocationQueryString());
        }
        return builder.toString();
    }

    public String getLocationPathString() {
        StringBuilder builder = new StringBuilder();
        for (String segment : this.getLocationPaths()) {
            builder.append(segment).append("/");
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public int getLocationPathCount() {
        return this.getLocationPaths().size();
    }

    public OptionSet addLocationPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Location path option must not be null");
        }
        if (path.length() > 255) {
            throw new IllegalArgumentException("Location path option's length must be between 0 and 255 inclusive");
        }
        this.getLocationPaths().add(path);
        return this;
    }

    public OptionSet removeLocationPath(String path) {
        this.getLocationPaths().remove(path);
        return this;
    }

    public OptionSet clearLocationPaths() {
        this.getLocationPaths().clear();
        return this;
    }

    public OptionSet setLocationPath(String path) {
        String[] parts;
        for (String segment : parts = path.split("/")) {
            if (segment.isEmpty()) continue;
            this.addLocationPath(segment);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getURIPaths() {
        if (this.uri_path_list == null) {
            OptionSet optionSet = this;
            synchronized (optionSet) {
                if (this.uri_path_list == null) {
                    this.uri_path_list = new LinkedList<String>();
                }
            }
        }
        return this.uri_path_list;
    }

    public String getURIPathString() {
        StringBuilder buffer = new StringBuilder();
        for (String element : this.getURIPaths()) {
            buffer.append(element).append("/");
        }
        if (buffer.length() == 0) {
            return "";
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    public int getURIPathCount() {
        return this.getURIPaths().size();
    }

    public OptionSet setURIPath(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        String slash = "/";
        while (path.startsWith(slash)) {
            path = path.substring(slash.length());
        }
        this.clearURIPaths();
        for (String segment : path.split(slash)) {
            if (segment.isEmpty()) continue;
            this.addURIPath(segment);
        }
        return this;
    }

    public OptionSet addURIPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("URI path option must not be null");
        }
        if (path.length() > 255) {
            throw new IllegalArgumentException("URI path option's length must be between 0 and 255 inclusive");
        }
        this.getURIPaths().add(path);
        return this;
    }

    public OptionSet removeURIPath(String path) {
        this.getURIPaths().remove(path);
        return this;
    }

    public OptionSet clearURIPaths() {
        this.getURIPaths().clear();
        return this;
    }

    public int getContentFormat() {
        return this.hasContentFormat() ? this.content_format : -1;
    }

    public boolean hasContentFormat() {
        return this.content_format != null;
    }

    public boolean hasContentFormat(int format) {
        return this.content_format != null && this.content_format == format;
    }

    public OptionSet setContentFormat(int format) {
        this.content_format = format;
        return this;
    }

    public OptionSet removeContentFormat() {
        this.content_format = null;
        return this;
    }

    public Long getMaxAge() {
        Long m = this.max_age;
        return m != null ? m : 60L;
    }

    public boolean hasMaxAge() {
        return this.max_age != null;
    }

    public OptionSet setMaxAge(long age) {
        if (age < 0L || 0xFFFFFFFFL < age) {
            throw new IllegalArgumentException("Max-Age option must be between 0 and 4294967295 (4 bytes) inclusive");
        }
        this.max_age = age;
        return this;
    }

    public OptionSet removeMaxAge() {
        this.max_age = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getURIQueries() {
        if (this.uri_query_list == null) {
            OptionSet optionSet = this;
            synchronized (optionSet) {
                if (this.uri_query_list == null) {
                    this.uri_query_list = new LinkedList<String>();
                }
            }
        }
        return this.uri_query_list;
    }

    public int getURIQueryCount() {
        return this.getURIQueries().size();
    }

    public OptionSet setURIQuery(String query) {
        if (query == null) {
            throw new NullPointerException();
        }
        String ampersand = "&";
        while (query.startsWith(ampersand)) {
            query = query.substring(ampersand.length());
        }
        this.clearURIQuery();
        for (String segment : query.split(ampersand)) {
            if (segment.isEmpty()) continue;
            this.addURIQuery(segment);
        }
        return this;
    }

    public String getURIQueryString() {
        StringBuilder builder = new StringBuilder();
        for (String query : this.getURIQueries()) {
            builder.append(query).append("&");
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public OptionSet addURIQuery(String query) {
        if (query == null) {
            throw new NullPointerException("URI-Query option must not be null");
        }
        if (query.length() > 255) {
            throw new IllegalArgumentException("URI-Qurty option's length must be between 0 and 255 inclusive");
        }
        this.getURIQueries().add(query);
        return this;
    }

    public OptionSet removeURIQuery(String query) {
        this.getURIQueries().remove(query);
        return this;
    }

    public OptionSet clearURIQuery() {
        this.getURIQueries().clear();
        return this;
    }

    public int getAccept() {
        return this.hasAccept() ? this.accept : -1;
    }

    public boolean hasAccept() {
        return this.accept != null;
    }

    public OptionSet setAccept(int acc) {
        if (acc < 0 || acc > 65535) {
            throw new IllegalArgumentException("Accept option must be between 0 and 65535 (2 bytes) inclusive");
        }
        this.accept = acc;
        return this;
    }

    public OptionSet removeAccept() {
        this.accept = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLocationQueries() {
        if (this.location_query_list == null) {
            OptionSet optionSet = this;
            synchronized (optionSet) {
                if (this.location_query_list == null) {
                    this.location_query_list = new LinkedList<String>();
                }
            }
        }
        return this.location_query_list;
    }

    public String getLocationQueryString() {
        StringBuilder builder = new StringBuilder();
        for (String query : this.getLocationQueries()) {
            builder.append(query).append("&");
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public OptionSet setLocationQuery(String query) {
        String[] parts;
        if (query.startsWith("?")) {
            query = query.substring(1);
        }
        for (String segment : parts = query.split("&")) {
            if (segment.isEmpty()) continue;
            this.addLocationQuery(segment);
        }
        return this;
    }

    public int getLocationQueryCount() {
        return this.getLocationQueries().size();
    }

    public OptionSet addLocationQuery(String query) {
        if (query == null) {
            throw new NullPointerException("Location Query option must not be null");
        }
        if (query.length() > 255) {
            throw new IllegalArgumentException("Location Query option's length must be between 0 and 255 inclusive");
        }
        this.getLocationQueries().add(query);
        return this;
    }

    public OptionSet removeLocationQuery(String query) {
        this.getLocationQueries().remove(query);
        return this;
    }

    public OptionSet clearLocationQuery() {
        this.getLocationQueries().clear();
        return this;
    }

    public String getProxyURI() {
        return this.proxy_uri;
    }

    public boolean hasProxyURI() {
        return this.proxy_uri != null;
    }

    public OptionSet setProxyURI(String uri) {
        if (uri == null) {
            throw new NullPointerException("Proxy URI option must not be null");
        }
        if (uri.length() < 1 || 1034 < uri.length()) {
            throw new IllegalArgumentException();
        }
        this.proxy_uri = uri;
        return this;
    }

    public OptionSet removeProxyURI() {
        this.proxy_uri = null;
        return this;
    }

    public String getProxyScheme() {
        return this.proxy_scheme;
    }

    public boolean hasProxyScheme() {
        return this.proxy_scheme != null;
    }

    public OptionSet setProxyScheme(String scheme) {
        if (scheme == null) {
            throw new NullPointerException("Proxy Scheme option must not be null");
        }
        if (scheme.length() < 1 || 255 < scheme.length()) {
            throw new IllegalArgumentException("Proxy Scheme option's length must be between 1 and 255 inclusive");
        }
        this.proxy_scheme = scheme;
        return this;
    }

    public OptionSet clearProxyScheme() {
        this.proxy_scheme = null;
        return this;
    }

    public BlockOption getBlock1() {
        return this.block1;
    }

    public boolean hasBlock1() {
        return this.block1 != null;
    }

    public void setBlock1(int szx, boolean m, int num) {
        this.block1 = new BlockOption(szx, m, num);
    }

    public void setBlock1(byte[] value) {
        this.block1 = new BlockOption(value);
    }

    public void setBlock1(BlockOption block1) {
        this.block1 = block1;
    }

    public void removeBlock1() {
        this.block1 = null;
    }

    public BlockOption getBlock2() {
        return this.block2;
    }

    public boolean hasBlock2() {
        return this.block2 != null;
    }

    public void setBlock2(int szx, boolean m, int num) {
        this.block2 = new BlockOption(szx, m, num);
    }

    public void setBlock2(byte[] value) {
        this.block2 = new BlockOption(value);
    }

    public void setBlock2(BlockOption block2) {
        this.block2 = block2;
    }

    public void removeBlock2() {
        this.block2 = null;
    }

    public Integer getObserve() {
        return this.observe;
    }

    public boolean hasObserve() {
        return this.observe != null;
    }

    public OptionSet setObserve(int observe) {
        if (observe < 0 || 0xFFFFFF < observe) {
            throw new IllegalArgumentException("Observe option must be between 0 and 16777215 (3 bytes) inclusive but was " + observe);
        }
        this.observe = observe;
        return this;
    }

    public OptionSet removeObserve() {
        this.observe = null;
        return this;
    }

    public boolean hasOption(int number) {
        return Collections.binarySearch(this.asSortedList(), new Option(number)) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Option> getOthers() {
        if (this.others == null) {
            OptionSet optionSet = this;
            synchronized (optionSet) {
                if (this.others == null) {
                    this.others = new LinkedList<Option>();
                }
            }
        }
        return this.others;
    }

    public List<Option> asSortedList() {
        ArrayList<Option> options = new ArrayList<Option>();
        if (this.if_match_list != null) {
            for (byte[] value : this.if_match_list) {
                options.add(new Option(1, value));
            }
        }
        if (this.hasURIHost()) {
            options.add(new Option(3, this.getURIHost()));
        }
        if (this.etag_list != null) {
            for (byte[] value : this.etag_list) {
                options.add(new Option(4, value));
            }
        }
        if (this.hasIfNoneMatch()) {
            options.add(new Option(5));
        }
        if (this.hasURIPort()) {
            options.add(new Option(7, this.getURIPort()));
        }
        if (this.location_path_list != null) {
            for (String str : this.location_path_list) {
                options.add(new Option(8, str));
            }
        }
        if (this.uri_path_list != null) {
            for (String str : this.uri_path_list) {
                options.add(new Option(11, str));
            }
        }
        if (this.hasContentFormat()) {
            options.add(new Option(12, this.getContentFormat()));
        }
        if (this.hasMaxAge()) {
            options.add(new Option(14, this.getMaxAge()));
        }
        if (this.uri_query_list != null) {
            for (String str : this.uri_query_list) {
                options.add(new Option(15, str));
            }
        }
        if (this.hasAccept()) {
            options.add(new Option(17, this.getAccept()));
        }
        if (this.location_query_list != null) {
            for (String str : this.location_query_list) {
                options.add(new Option(20, str));
            }
        }
        if (this.hasProxyURI()) {
            options.add(new Option(35, this.getProxyURI()));
        }
        if (this.hasProxyScheme()) {
            options.add(new Option(39, this.getProxyScheme()));
        }
        if (this.hasBlock1()) {
            options.add(new Option(27, this.getBlock1().getValue()));
        }
        if (this.hasBlock2()) {
            options.add(new Option(23, this.getBlock2().getValue()));
        }
        if (this.hasObserve()) {
            options.add(new Option(6, this.getObserve()));
        }
        if (this.others != null) {
            options.addAll(this.others);
        }
        Collections.sort(options);
        return options;
    }

    public OptionSet addOption(Option o) {
        this.getOthers().add(o);
        return this;
    }

    public String toString() {
        ArrayList<String> os = new ArrayList<String>();
        if (this.if_match_list != null && this.getIfMatchCount() > 0) {
            os.add("If-Match=" + this.toHexString(this.if_match_list));
        }
        if (this.hasURIHost()) {
            os.add("URI-Host=" + this.uri_host);
        }
        if (this.etag_list != null && this.getETagCount() > 0) {
            os.add("ETag=" + this.toHexString(this.etag_list));
        }
        if (this.hasIfNoneMatch()) {
            os.add("If-None-Match=" + this.if_none_match);
        }
        if (this.hasURIPort()) {
            os.add("URI-Port=" + this.uri_port);
        }
        if (this.location_path_list != null && this.getLocationPathCount() > 0) {
            os.add("Location-Path=" + Arrays.toString(this.location_path_list.toArray()));
        }
        if (this.uri_path_list != null && this.getURIPathCount() > 0) {
            os.add("URI-Path=" + Arrays.toString(this.uri_path_list.toArray()));
        }
        if (this.hasContentFormat()) {
            os.add("Content-Format=" + this.content_format);
        }
        if (this.hasMaxAge()) {
            os.add("Max-Age=" + this.max_age);
        }
        if (this.uri_query_list != null && this.getURIQueryCount() > 0) {
            os.add("URI-Query=" + Arrays.toString(this.uri_query_list.toArray()));
        }
        if (this.hasAccept()) {
            os.add("Accept=" + this.accept);
        }
        if (this.location_query_list != null && this.getLocationQueryCount() > 0) {
            os.add("Location-Query=" + Arrays.toString(this.location_query_list.toArray()));
        }
        if (this.hasProxyURI()) {
            os.add("Proxy-URI=" + this.proxy_uri);
        }
        if (this.hasProxyScheme()) {
            os.add("Proxy-Scheme=" + this.proxy_scheme);
        }
        if (this.hasBlock1()) {
            os.add("Block1=" + this.block1);
        }
        if (this.hasBlock2()) {
            os.add("Block2=" + this.block2);
        }
        if (this.hasObserve()) {
            os.add("Observe=" + this.observe);
        }
        if (this.others != null) {
            for (Option o : this.others) {
                os.add(o.toString());
            }
        }
        return "OptionSet=" + Arrays.toString(os.toArray());
    }

    private String toHexString(List<byte[]> list) {
        ArrayList<String> hexs = new ArrayList<String>(list.size());
        for (byte[] bytes : list) {
            hexs.add(this.toHexString(bytes));
        }
        return Arrays.toString(hexs.toArray());
    }

    private String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

