/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.OptionSet;

public abstract class Message {
    protected static final Logger LOGGER = Logger.getLogger(Message.class.getCanonicalName());
    public static final int NONE = -1;
    private CoAP.Type type;
    private int mid = -1;
    private byte[] token;
    private OptionSet options;
    private byte[] payload;
    private String payloadString;
    private InetAddress destination;
    private InetAddress source;
    private int destinationPort;
    private int sourcePort;
    private boolean acknowledged;
    private boolean rejected;
    private boolean canceled;
    private boolean timedOut;
    private boolean duplicate;
    private byte[] bytes;
    private List<MessageObserver> handlers = null;
    private long timestamp;

    public Message() {
    }

    public Message(CoAP.Type type) {
        this.type = type;
    }

    public CoAP.Type getType() {
        return this.type;
    }

    public void setType(CoAP.Type type) {
        this.type = type;
    }

    public boolean isConfirmable() {
        return this.getType() == CoAP.Type.CON;
    }

    public void setConfirmable(boolean con) {
        this.setType(con ? CoAP.Type.CON : CoAP.Type.NON);
    }

    public int getMID() {
        return this.mid;
    }

    public void setMID(int mid) {
        if (mid >= 65536 || mid < -1) {
            throw new IllegalArgumentException("The MID must be a 16-bit number between 0 and 65535 inclusive but was " + mid);
        }
        this.mid = mid;
    }

    public void removeMID() {
        this.setMID(-1);
    }

    public byte[] getToken() {
        return this.token;
    }

    public boolean hasEmptyToken() {
        return this.token == null || this.token.length == 0;
    }

    public String getTokenString() {
        StringBuffer tok = new StringBuffer(this.getToken() == null ? "null" : "");
        if (this.getToken() != null) {
            for (byte b : this.getToken()) {
                tok.append(String.format("%02x", b & 0xFF));
            }
        }
        return tok.toString();
    }

    public void setToken(byte[] token) {
        if (token != null && token.length > 8) {
            throw new IllegalArgumentException("Token length must be between 0 and 8 inclusive");
        }
        this.token = token;
    }

    public OptionSet getOptions() {
        if (this.options == null) {
            this.options = new OptionSet();
        }
        return this.options;
    }

    public void setOptions(OptionSet options) {
        this.options = options;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getPayloadString() {
        if (this.payload == null) {
            return null;
        }
        this.payloadString = new String(this.payload);
        return this.payloadString;
    }

    public int getPayloadSize() {
        return this.payload == null ? 0 : this.payload.length;
    }

    public Message setPayload(String payload) {
        if (payload == null) {
            throw new NullPointerException();
        }
        this.setPayload(payload.getBytes());
        return this;
    }

    public Message setPayload(String payload, int mediaType) {
        this.setPayload(payload);
        this.getOptions().setContentFormat(mediaType);
        return this;
    }

    public Message setPayload(byte[] payload) {
        this.payload = payload;
        this.payloadString = null;
        return this;
    }

    public InetAddress getDestination() {
        return this.destination;
    }

    public void setDestination(InetAddress destination) {
        this.destination = destination;
    }

    public InetAddress getSource() {
        return this.source;
    }

    public void setSource(InetAddress source) {
        this.source = source;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public void setDestinationPort(int destinationPort) {
        this.destinationPort = destinationPort;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public void setAcknowledged(boolean acknowledged) {
        this.acknowledged = acknowledged;
        if (acknowledged) {
            for (MessageObserver handler : this.getMessageObservers()) {
                handler.onAcknowledgement();
            }
        }
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setRejected(boolean rejected) {
        this.rejected = rejected;
        if (rejected) {
            for (MessageObserver handler : this.getMessageObservers()) {
                handler.onReject();
            }
        }
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
        if (timedOut) {
            for (MessageObserver handler : this.getMessageObservers()) {
                handler.onTimeout();
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (canceled) {
            for (MessageObserver handler : this.getMessageObservers()) {
                handler.onCancel();
            }
        }
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void cancel() {
        this.setCanceled(true);
    }

    public void retransmitting() {
        for (MessageObserver handler : this.getMessageObservers()) {
            try {
                handler.onRetransmission();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Faulty MessageObserver for retransmitting events.", e);
            }
        }
    }

    public List<MessageObserver> getMessageObservers() {
        List<MessageObserver> handlers = this.handlers;
        if (handlers == null) {
            return Collections.emptyList();
        }
        return handlers;
    }

    public void addMessageObserver(MessageObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (this.handlers == null) {
            this.createMessageObserver();
        }
        this.handlers.add(observer);
    }

    public void removeMessageObserver(MessageObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (this.handlers == null) {
            return;
        }
        this.handlers.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageObserver() {
        if (this.handlers == null) {
            Message message = this;
            synchronized (message) {
                if (this.handlers == null) {
                    this.handlers = new CopyOnWriteArrayList<MessageObserver>();
                }
            }
        }
    }
}

