/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.dtls.CertificateIdentityResult;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCertificateProvider
extends SingleCertificateProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCertificateProvider.class);
    private static final NamedThreadFactory THREAD_FACTORY = new DaemonThreadFactory("AsyncCertProvider#", NamedThreadFactory.SCANDIUM_THREAD_GROUP);
    private final ScheduledExecutorService executorService = ExecutorsUtil.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private volatile int delayMillis = 1;
    private volatile HandshakeResultHandler resultHandler;

    public AsyncCertificateProvider(PrivateKey privateKey, Certificate[] chain, CertificateType ... supportedCertificateTypes) {
        super(privateKey, chain, supportedCertificateTypes);
    }

    public AsyncCertificateProvider(PrivateKey privateKey, Certificate[] chain, List<CertificateType> supportedCertificateTypes) {
        super(privateKey, chain, supportedCertificateTypes);
    }

    public AsyncCertificateProvider(PrivateKey privateKey, PublicKey publicKey) {
        super(privateKey, publicKey);
    }

    public AsyncCertificateProvider setDelay(int delayMillis) {
        this.delayMillis = delayMillis;
        if (delayMillis > 0) {
            LOGGER.info("Asynchronous delayed certificate provider {}ms.", (Object)delayMillis);
        } else if (delayMillis < 0) {
            LOGGER.info("Synchronous delayed certificate provider {}ms.", (Object)(-delayMillis));
        } else {
            LOGGER.info("Synchronous certificate provider.");
        }
        return this;
    }

    public int getDelay() {
        return this.delayMillis;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public CertificateIdentityResult requestCertificateIdentity(final ConnectionId cid, final boolean client, final List<X500Principal> issuers, final ServerNames serverNames, final List<CipherSuite.CertificateKeyAlgorithm> certificateKeyAlgorithms, final List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, final List<XECDHECryptography.SupportedGroup> curves) {
        if (this.delayMillis <= 0) {
            if (this.delayMillis < 0) {
                try {
                    Thread.sleep(-this.delayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.requestCertificateIdentity(cid, client, issuers, serverNames, certificateKeyAlgorithms, signatureAndHashAlgorithms, curves);
        }
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                CertificateIdentityResult result = AsyncCertificateProvider.super.requestCertificateIdentity(cid, client, issuers, serverNames, certificateKeyAlgorithms, signatureAndHashAlgorithms, curves);
                AsyncCertificateProvider.this.resultHandler.apply(result);
            }
        }, (long)this.delayMillis, TimeUnit.MILLISECONDS);
        return null;
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
        if (this.resultHandler != null && resultHandler != null && this.resultHandler != resultHandler) {
            throw new IllegalStateException("handshake result handler already set!");
        }
        this.resultHandler = resultHandler;
    }
}

