/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;

public class SignatureAlgorithmsExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 16;
    private static final int SIGNATURE_ALGORITHM_BITS = 16;
    private static final int SIGNATURE_BITS = 8;
    private static final int HASH_BITS = 8;
    private final List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms;

    public SignatureAlgorithmsExtension(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
        super(HelloExtension.ExtensionType.SIGNATURE_ALGORITHMS);
        this.signatureAndHashAlgorithms = signatureAndHashAlgorithms;
    }

    public List<SignatureAndHashAlgorithm> getSupportedSignatureAndHashAlgorithms() {
        return this.signatureAndHashAlgorithms;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        String indentation2 = StringUtil.indentation(indent + 2);
        sb.append(indentation).append("Signature Algorithms (").append(this.signatureAndHashAlgorithms.size()).append(" algorithms):").append(StringUtil.lineSeparator());
        for (SignatureAndHashAlgorithm signatureAndHashAlgoritm : this.signatureAndHashAlgorithms) {
            sb.append(indentation2).append("Signature and Hash Algorithm: ").append(signatureAndHashAlgoritm).append(StringUtil.lineSeparator());
        }
        return sb.toString();
    }

    @Override
    protected int getExtensionLength() {
        return 2 + this.signatureAndHashAlgorithms.size() * 2;
    }

    @Override
    protected void writeExtensionTo(DatagramWriter writer) {
        int listLength = this.signatureAndHashAlgorithms.size() * 2;
        writer.write(listLength, 16);
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : this.signatureAndHashAlgorithms) {
            writer.write(signatureAndHashAlgorithm.getHash().getCode(), 8);
            writer.write(signatureAndHashAlgorithm.getSignature().getCode(), 8);
        }
    }

    public static SignatureAlgorithmsExtension fromExtensionDataReader(DatagramReader extensionDataReader) {
        ArrayList<SignatureAndHashAlgorithm> signatureAndHashAlgorithms = new ArrayList();
        int listLength = extensionDataReader.read(16);
        DatagramReader rangeReader = extensionDataReader.createRangeReader(listLength);
        while (rangeReader.bytesAvailable()) {
            int hashId = rangeReader.read(8);
            int signatureId = rangeReader.read(8);
            signatureAndHashAlgorithms.add(new SignatureAndHashAlgorithm(hashId, signatureId));
        }
        signatureAndHashAlgorithms = Collections.unmodifiableList(signatureAndHashAlgorithms);
        return new SignatureAlgorithmsExtension(signatureAndHashAlgorithms);
    }
}

