/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;

public final class ConnectionIdExtension
extends HelloExtension {
    private static final int CID_FIELD_LENGTH_BITS = 8;
    private final ConnectionId id;

    private ConnectionIdExtension(ConnectionId id) {
        super(HelloExtension.ExtensionType.CONNECTION_ID);
        this.id = id;
    }

    public ConnectionId getConnectionId() {
        return this.id;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        sb.append(indentation).append("DTLS Conection ID: ").append(this.id).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    protected int getExtensionLength() {
        return 1 + this.id.length();
    }

    @Override
    protected void writeExtensionTo(DatagramWriter writer) {
        writer.writeVarBytes(this.id, 8);
    }

    public static ConnectionIdExtension fromConnectionId(ConnectionId cid) {
        if (cid == null) {
            throw new NullPointerException("cid must not be null!");
        }
        return new ConnectionIdExtension(cid);
    }

    public static ConnectionIdExtension fromExtensionDataReader(DatagramReader extensionDataReader) throws HandshakeException {
        if (extensionDataReader == null) {
            throw new NullPointerException("cid must not be null!");
        }
        int availableBytes = extensionDataReader.bitsLeft() / 8;
        if (availableBytes == 0) {
            throw new HandshakeException("Connection id length must be provided!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        if (availableBytes > 256) {
            throw new HandshakeException("Connection id length too large! 255 max, but has " + (availableBytes - 1), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        int len = extensionDataReader.read(8);
        if (len != availableBytes - 1) {
            throw new HandshakeException("Connection id length " + len + " doesn't match " + (availableBytes - 1) + "!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        if (len == 0) {
            return new ConnectionIdExtension(ConnectionId.EMPTY);
        }
        byte[] cid = extensionDataReader.readBytes(len);
        return new ConnectionIdExtension(new ConnectionId(cid));
    }
}

