/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;
import org.eclipse.californium.scandium.util.SecretUtil;

public class SecretSerializationUtil {
    public static void write(DatagramWriter writer, SecretKey key) {
        if (key == null || SecretUtil.isDestroyed(key)) {
            writer.writeVarBytes((byte[])null, 8);
        } else {
            byte[] encoded = key.getEncoded();
            writer.writeVarBytes(encoded, 8);
            Bytes.clear(encoded);
            SerializationUtil.write(writer, key.getAlgorithm(), 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey readSecretKey(DatagramReader reader) {
        SecretKey key = null;
        byte[] data = reader.readVarBytes(8);
        if (data != null) {
            if (data.length == 0) {
                throw new IllegalArgumentException("key must not be empty!");
            }
            try {
                String algo = SerializationUtil.readString(reader, 8);
                if (algo == null) {
                    throw new IllegalArgumentException("key must have algorithm!");
                }
                key = SecretUtil.create(data, algo.intern());
            }
            finally {
                Bytes.clear(data);
            }
        }
        return key;
    }

    public static void write(DatagramWriter writer, SecretIvParameterSpec iv) {
        if (iv == null || SecretUtil.isDestroyed(iv)) {
            writer.write(0, 8);
        } else {
            writer.write(iv.size(), 8);
            iv.writeTo(writer);
        }
    }

    public static SecretIvParameterSpec readIv(DatagramReader reader) {
        byte[] data = reader.readVarBytes(8);
        if (data != null) {
            SecretIvParameterSpec iv = SecretUtil.createIv(data);
            Bytes.clear(data);
            return iv;
        }
        return null;
    }
}

