/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;

@NoPublicAPI
public class ECDHClientKeyExchange
extends ClientKeyExchange {
    private static final int LENGTH_BITS = 8;
    private final byte[] encodedPoint;

    public ECDHClientKeyExchange(byte[] encodedPoint) {
        if (encodedPoint == null) {
            throw new NullPointerException("encoded point cannot be null");
        }
        this.encodedPoint = encodedPoint;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        this.writeFragment(writer);
        return writer.toByteArray();
    }

    protected void writeFragment(DatagramWriter writer) {
        writer.writeVarBytes(this.encodedPoint, 8);
    }

    protected static byte[] readEncodedPoint(DatagramReader reader) {
        return reader.readVarBytes(8);
    }

    public static HandshakeMessage fromReader(DatagramReader reader) {
        byte[] pointEncoded = ECDHClientKeyExchange.readEncodedPoint(reader);
        return new ECDHClientKeyExchange(pointEncoded);
    }

    @Override
    public int getMessageLength() {
        return 1 + this.encodedPoint.length;
    }

    public byte[] getEncodedPoint() {
        return Arrays.copyOf(this.encodedPoint, this.encodedPoint.length);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        sb.append(indentation).append("Diffie-Hellman public value: ");
        sb.append(StringUtil.byteArray2HexString(this.encodedPoint, '\u0000', 16));
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }
}

