/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;

public class MaxFragmentLengthExtension
extends HelloExtension {
    public static final int CODE_BITS = 8;
    private final Length fragmentLength;

    public MaxFragmentLengthExtension(Length fragmentLength) {
        super(HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH);
        if (fragmentLength == null) {
            throw new NullPointerException("Length must not be null");
        }
        this.fragmentLength = fragmentLength;
    }

    public Length getFragmentLength() {
        return this.fragmentLength;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        sb.append(indentation).append("Code: ").append(this.fragmentLength.code()).append(" (").append(this.fragmentLength.length()).append(" bytes)").append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    protected int getExtensionLength() {
        return 1;
    }

    @Override
    protected void writeExtensionTo(DatagramWriter writer) {
        writer.write(this.fragmentLength.code, 8);
    }

    public static MaxFragmentLengthExtension fromExtensionDataReader(DatagramReader extensionDataReader) throws HandshakeException {
        int code = extensionDataReader.read(8);
        Length length = Length.fromCode(code);
        if (length != null) {
            return new MaxFragmentLengthExtension(length);
        }
        throw new HandshakeException(String.format("Peer uses unknown code [%d] in %s extension", code, HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH.name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
    }

    public static enum Length {
        BYTES_512(1, 512),
        BYTES_1024(2, 1024),
        BYTES_2048(3, 2048),
        BYTES_4096(4, 4096);

        private final int code;
        private final int length;

        private Length(int code, int length) {
            this.code = code;
            this.length = length;
        }

        public int code() {
            return this.code;
        }

        public int length() {
            return this.length;
        }

        public static Length fromCode(int code) {
            switch (code) {
                case 1: {
                    return BYTES_512;
                }
                case 2: {
                    return BYTES_1024;
                }
                case 3: {
                    return BYTES_2048;
                }
                case 4: {
                    return BYTES_4096;
                }
            }
            return null;
        }
    }
}

