/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.oscore.OSSerializer;

public class OscoreOptionEncoder {
    private boolean encoded;
    private byte[] encodedBytes;
    private byte[] idContext;
    private byte[] partialIV;
    private byte[] kid;

    public byte[] getBytes() {
        if (!this.encoded) {
            this.encodedBytes = this.encode();
        }
        return this.encodedBytes;
    }

    private byte[] encode() {
        boolean hasKid;
        int firstByte = 0;
        ByteArrayOutputStream bRes = new ByteArrayOutputStream();
        boolean hasContextID = this.idContext != null;
        boolean hasPartialIV = this.partialIV != null;
        boolean bl = hasKid = this.kid != null;
        if (hasContextID) {
            firstByte |= 0x10;
        }
        if (hasKid) {
            firstByte |= 8;
        }
        if (hasPartialIV) {
            byte[] partialIV = this.partialIV;
            bRes.write(firstByte |= partialIV.length & 7);
            try {
                bRes.write(partialIV);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            bRes.write(firstByte);
        }
        if (hasContextID) {
            try {
                bRes.write(this.idContext.length);
                bRes.write(this.idContext);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (hasKid) {
            try {
                bRes.write(this.kid);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.encoded = true;
        byte[] optionBytes = bRes.toByteArray();
        if (optionBytes.length == 1 && optionBytes[0] == 0) {
            return Bytes.EMPTY;
        }
        return optionBytes;
    }

    public byte[] getIdContext() {
        return this.idContext;
    }

    public void setIdContext(byte[] idContext) {
        this.encoded = false;
        this.idContext = idContext;
    }

    public byte[] getPartialIV() {
        return this.partialIV;
    }

    public void setPartialIV(byte[] partialIV) {
        this.encoded = false;
        this.partialIV = partialIV;
    }

    public void setPartialIV(int senderSeq) {
        this.encoded = false;
        this.partialIV = OSSerializer.processPartialIV(senderSeq);
    }

    public byte[] getKid() {
        return this.kid;
    }

    public void setKid(byte[] kid) {
        this.encoded = false;
        this.kid = kid;
    }
}

