/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import com.upokecenter.cbor.CBORObject;
import java.nio.ByteBuffer;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.cose.AlgorithmID;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.OptionJuggle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSerializer {
    private static final byte[] ONE_ZERO = new byte[]{0};
    private static final Logger LOGGER = LoggerFactory.getLogger(OSSerializer.class);

    public static byte[] serializeConfidentialData(OptionSet options, byte[] payload, int realCode) {
        if (options != null) {
            DatagramWriter writer = new DatagramWriter();
            if (realCode > 0) {
                OptionSet filteredOptions = OptionJuggle.prepareEoptions(options);
                writer.write(realCode, 8);
                DataSerializer.serializeOptionsAndPayload(writer, filteredOptions, payload);
                return writer.toByteArray();
            }
            LOGGER.error("Coap Code is invalid");
            throw new IllegalArgumentException("Coap Code is invalid");
        }
        LOGGER.error("OptionSet is null");
        throw new NullPointerException("OptionSet is null");
    }

    public static byte[] serializeAAD(int version, AlgorithmID algorithm, int requestSeq, byte[] requestSenderId, OptionSet options) {
        if (version == 1) {
            if (requestSeq > -1) {
                if (algorithm != null) {
                    if (options != null) {
                        CBORObject algorithms = CBORObject.NewArray();
                        algorithms.Add(algorithm.AsCBOR());
                        CBORObject aad = CBORObject.NewArray();
                        aad.Add(version);
                        aad.Add(algorithms);
                        aad.Add(requestSenderId);
                        aad.Add(OSSerializer.processPartialIV(requestSeq));
                        aad.Add(CBORObject.FromObject(Bytes.EMPTY));
                        return aad.EncodeToBytes();
                    }
                    LOGGER.error("OptionSet is null");
                    throw new NullPointerException("OptionSet is null");
                }
                LOGGER.error("Algorithm not defined");
                throw new NullPointerException("Algorithm not defined");
            }
            LOGGER.error("Sequence number is invalid");
            throw new IllegalArgumentException("Sequence number is invalid");
        }
        LOGGER.error("Wrong version number");
        throw new IllegalArgumentException("Wrong version number");
    }

    public static byte[] nonceGeneration(byte[] partialIV, byte[] senderID, byte[] commonIV, int nonceLength) throws OSException {
        if (partialIV != null) {
            if (senderID != null) {
                if (commonIV != null) {
                    if (nonceLength > 0) {
                        int s = senderID.length;
                        int zeroes = 5 - partialIV.length;
                        if (zeroes > 0) {
                            partialIV = OSSerializer.leftPaddingZeroes(partialIV, zeroes);
                        }
                        if ((zeroes = nonceLength - 6 - senderID.length) > 0) {
                            senderID = OSSerializer.leftPaddingZeroes(senderID, zeroes);
                        }
                        if ((zeroes = nonceLength - commonIV.length) > 0) {
                            commonIV = OSSerializer.leftPaddingZeroes(commonIV, zeroes);
                        }
                        byte[] tmp = new byte[1 + senderID.length + partialIV.length];
                        tmp[0] = (byte)s;
                        System.arraycopy(senderID, 0, tmp, 1, senderID.length);
                        System.arraycopy(partialIV, 0, tmp, senderID.length + 1, partialIV.length);
                        byte[] result = new byte[commonIV.length];
                        int i = 0;
                        for (byte b : tmp) {
                            result[i] = (byte)(b ^ commonIV[i++]);
                        }
                        return result;
                    }
                    LOGGER.error("Nonce length is invalid");
                    throw new IllegalArgumentException("Nonce length is invalid");
                }
                LOGGER.error("CommonIV is null");
                throw new NullPointerException("CommonIV is null");
            }
            LOGGER.error("SenderID is null");
            throw new NullPointerException("SenderID is null");
        }
        LOGGER.error("PartialIV is null");
        throw new NullPointerException("PartialIV is null");
    }

    public static byte[] leftPaddingZeroes(byte[] paddMe, int zeros) {
        byte[] tmp = new byte[zeros + paddMe.length];
        System.arraycopy(paddMe, 0, tmp, zeros, paddMe.length);
        return tmp;
    }

    public static byte[] processPartialIV(int value) {
        byte[] partialIV = ByteBuffer.allocate(4).putInt(value).array();
        return OSSerializer.stripZeroes(partialIV);
    }

    public static byte[] stripZeroes(byte[] in) {
        if (in != null) {
            int firstValue;
            if (in.length == 0) {
                return Bytes.EMPTY;
            }
            if (in.length == 1) {
                return in;
            }
            for (firstValue = 0; firstValue < in.length && in[firstValue] == 0; ++firstValue) {
            }
            int newLength = in.length - firstValue;
            if (newLength == 0) {
                return ONE_ZERO;
            }
            byte[] out = new byte[newLength];
            System.arraycopy(in, firstValue, out, 0, out.length);
            return out;
        }
        LOGGER.error("Byte array is null");
        throw new NullPointerException("Byte array is null");
    }
}

