/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class ConnectorConfig
implements Cloneable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConnectorConfig.class);
    public static final int MAX_WIDTH = 60;
    public static final String PSK_IDENTITY_PREFIX = "cali.";
    public static final SecretKey PSK_SECRET = SecretUtil.create((byte[])".fornium".getBytes(), (String)"PSK");
    public String defaultEcCredentials = ConnectorConfig.createDescriptor("certs/keyStore.jks", "endPass".toCharArray(), "endPass".toCharArray(), "client");
    public String defaultEcTrusts = ConnectorConfig.createDescriptor("certs/trustStore.jks", "rootPass".toCharArray(), null, null);
    public String configurationHeader = "Californium3 CoAP Properties file";
    public Configuration.DefinitionsProvider customConfigurationDefaultsProvider;
    public Configuration configuration;
    @CommandLine.Option(names={"-C", "--config"}, paramLabel="FILE", description={"configuration file. Default ${DEFAULT-VALUE}."})
    public File configurationFile;
    @CommandLine.Option(names={"--tag"}, description={"use logging tag."})
    public String tag;
    @CommandLine.Option(names={"--record-size"}, description={"record size limit."})
    public Integer recordSizeLimit;
    @CommandLine.Option(names={"--mtu"}, description={"MTU."})
    public Integer mtu;
    @CommandLine.Option(names={"--extended-master-secret"}, description={"Specify usage of extended master secret."})
    public ExtendedMasterSecretMode extendedMasterSecretMode;
    @CommandLine.Option(names={"--cid-length"}, description={"Use cid with length. 0 to support cid only without using it."})
    public Integer cidLength;
    @CommandLine.ArgGroup(exclusive=true)
    public Authentication authentication;
    @CommandLine.ArgGroup(exclusive=true)
    public Trust trust;
    @CommandLine.Option(names={"--psk-index"}, description={"Index of identity in PSK store. Starts at 0."})
    public Integer pskIndex;
    @CommandLine.Option(names={"--psk-store"}, description={"PSK store. Lines format: identity=secretkey (in base64)."})
    public PskCredentialStore pskStore;
    @CommandLine.Option(names={"--cipher"}, split=":", description={"use ciphersuites. '--help-cipher' to list available cipher suites."})
    public List<CipherSuite> cipherSuites;
    @CommandLine.Option(names={"-a", "--auth"}, split=":", description={"use authentikation modes. '--help-auth' to list available authentication modes."})
    public List<AuthenticationMode> authenticationModes;
    @CommandLine.Option(names={"-i", "--identity"}, description={"PSK identity"})
    public String identity;
    @CommandLine.ArgGroup(exclusive=true)
    public Secret secret;
    @CommandLine.Option(names={"-v", "--verbose"}, negatable=true, description={"verbose"})
    public boolean verbose;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display a help message"})
    public boolean helpRequested;
    @CommandLine.Option(names={"--help-cipher"}, description={"display a help message for cipher suites"})
    public boolean cipherHelpRequested;
    @CommandLine.Option(names={"--help-auth"}, description={"display a help message for authentication modes"})
    public boolean authHelpRequested;
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, description={"display version info"})
    boolean versionInfoRequested;
    public byte[] secretKey;
    protected CommandLine.IDefaultValueProvider defaultValueProvider = new CommandLine.IDefaultValueProvider(){

        public String defaultValue(CommandLine.Model.ArgSpec argSpec) throws Exception {
            CommandLine.Model.OptionSpec optionSpec;
            if (argSpec instanceof CommandLine.Model.OptionSpec && "--config".equals((optionSpec = (CommandLine.Model.OptionSpec)argSpec).longestName())) {
                if (ConnectorConfig.this.configurationFile != null) {
                    return ConnectorConfig.this.configurationFile.getPath();
                }
                return "Californium3.properties";
            }
            return null;
        }
    };
    private static CommandLine.ITypeConverter<TrustedCertificates> trustsReader = new CommandLine.ITypeConverter<TrustedCertificates>(){

        public TrustedCertificates convert(String value) throws Exception {
            return new TrustedCertificates(SslContextUtil.loadTrustedCertificates((String)value));
        }
    };
    private static CommandLine.ITypeConverter<SslContextUtil.Credentials> credentialsReader = new CommandLine.ITypeConverter<SslContextUtil.Credentials>(){

        public SslContextUtil.Credentials convert(String value) throws Exception {
            try {
                return SslContextUtil.loadCredentials((String)value);
            }
            catch (SslContextUtil.IncompleteCredentialsException ex) {
                return ex.getIncompleteCredentials();
            }
        }
    };
    private static CommandLine.ITypeConverter<PskCredentialStore> pskCredentialsStoreReader = new CommandLine.ITypeConverter<PskCredentialStore>(){

        public PskCredentialStore convert(String value) throws Exception {
            return ConnectorConfig.loadPskCredentials(value);
        }
    };

    public void register(CommandLine cmd) {
        cmd.registerConverter(SslContextUtil.Credentials.class, credentialsReader);
        cmd.registerConverter(TrustedCertificates.class, trustsReader);
        cmd.registerConverter(PskCredentialStore.class, pskCredentialsStoreReader);
        cmd.setDefaultValueProvider(this.defaultValueProvider);
    }

    public void defaults() {
        if (this.pskStore != null) {
            if (this.identity != null || this.secret != null) {
                System.err.println("Use either '--psk-store' or single psk credentials!");
                this.helpRequested = true;
            }
            if (this.pskIndex != null) {
                this.secret = new Secret();
                this.secret.hex = StringUtil.byteArray2Hex((byte[])this.pskStore.getSecrets(this.pskIndex));
                this.identity = this.pskStore.getIdentity(this.pskIndex);
            }
        }
        if (this.secret != null && this.secretKey == null) {
            this.secretKey = this.secret.toKey();
        }
        if (this.authenticationModes == null) {
            this.authenticationModes = new ArrayList<AuthenticationMode>();
        }
        if (this.authenticationModes.isEmpty()) {
            this.defaultAuthenticationModes();
        }
        if (this.authenticationModes.contains((Object)AuthenticationMode.X509) || this.authenticationModes.contains((Object)AuthenticationMode.RPK)) {
            if (this.trust == null) {
                this.trust = new Trust();
            }
            this.trust.defaults(this.defaultEcTrusts);
            if (this.authentication == null) {
                this.authentication = new Authentication();
            }
            this.authentication.defaults(this.defaultEcCredentials);
        }
        if (this.cipherHelpRequested || this.authHelpRequested) {
            this.helpRequested = true;
        }
        CoapConfig.register();
        UdpConfig.register();
        DtlsConfig.register();
        Configuration.DefinitionsProvider provider = new Configuration.DefinitionsProvider(){

            public void applyDefinitions(Configuration config) {
                config.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.CLIENT_ONLY);
                config.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, (Object)false);
                if (ConnectorConfig.this.customConfigurationDefaultsProvider != null) {
                    ConnectorConfig.this.customConfigurationDefaultsProvider.applyDefinitions(config);
                }
            }
        };
        this.configuration = Configuration.createWithFile((File)this.configurationFile, (String)this.configurationHeader, (Configuration.DefinitionsProvider)provider);
    }

    protected void defaultAuthenticationModes() {
        if (this.identity != null || this.secretKey != null || this.pskStore != null) {
            this.authenticationModes.add(AuthenticationMode.PSK);
        }
        if (this.authentication != null) {
            this.authenticationModes.add(AuthenticationMode.X509);
        }
    }

    public static String createDescriptor(String store, char[] storePass, char[] keyPass, String alias) {
        StringBuilder descriptor = new StringBuilder("classpath://");
        descriptor.append(store).append('#');
        if (storePass != null) {
            descriptor.append(StringUtil.charArray2hex((char[])storePass)).append('#');
        }
        if (keyPass != null) {
            descriptor.append(StringUtil.charArray2hex((char[])keyPass)).append('#');
        }
        if (alias != null) {
            descriptor.append(alias);
        }
        return descriptor.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PskCredentialStore loadPskCredentials(String file) {
        boolean error = false;
        BufferedReader lineReader = null;
        try (FileReader reader = new FileReader(file);){
            String line;
            PskCredentialStore pskCredentials = new PskCredentialStore();
            int lineNumber = 0;
            lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                ++lineNumber;
                String[] entry = line.split("=", 2);
                if (entry.length == 2) {
                    byte[] secretBytes = StringUtil.base64ToByteArray((String)entry[1]);
                    pskCredentials.add(entry[0], secretBytes);
                    continue;
                }
                error = true;
                LOGGER.error("{}: '{}' invalid psk-line!", (Object)lineNumber, (Object)line);
            }
            if (!error) {
                PskCredentialStore pskCredentialStore = pskCredentials;
                return pskCredentialStore;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (lineReader != null) {
                try {
                    lineReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static class PskCredentialStore {
        private List<String> identities = new ArrayList<String>();
        private List<byte[]> secrets = new ArrayList<byte[]>();

        private void add(String identity, byte[] secret) {
            this.identities.add(identity);
            this.secrets.add(secret);
        }

        public String getIdentity(int index) {
            return this.identities.get(index);
        }

        public byte[] getSecrets(int index) {
            return this.secrets.get(index);
        }

        public int size() {
            return this.secrets.size();
        }
    }

    public static class Secret {
        @CommandLine.Option(names={"-s", "--secret"}, description={"PSK secret, UTF-8"})
        public String text;
        @CommandLine.Option(names={"--secrethex"}, description={"PSK secret, hexadecimal"})
        public String hex;
        @CommandLine.Option(names={"--secret64"}, description={"PSK secret, base64"})
        public String base64;

        public byte[] toKey() {
            if (this.text != null && this.text.length() > 0) {
                return this.text.getBytes();
            }
            if (this.hex != null && this.hex.length() > 0) {
                return StringUtil.hex2ByteArray((String)this.hex);
            }
            if (this.base64 != null && this.base64.length() > 0) {
                return StringUtil.base64ToByteArray((String)this.base64);
            }
            return null;
        }
    }

    public static class Trust {
        public Certificate[] trusts;
        @CommandLine.Option(names={"-t", "--trusts"}, description={"trusted certificates. Format keystore#hexstorepwd#alias or truststore.pem"})
        public TrustedCertificates trusted;
        @CommandLine.Option(names={"--trust-all"}, description={"trust all valid certificates."})
        public boolean trustall;

        public void defaults(String defaultEcTrusts) {
            if (this.trusted != null && this.trusts == null) {
                this.trusts = this.trusted.trusts;
            }
            if (this.trusts == null) {
                if (this.trustall) {
                    this.trusts = new Certificate[0];
                } else {
                    try {
                        this.trusts = SslContextUtil.loadTrustedCertificates((String)defaultEcTrusts);
                    }
                    catch (GeneralSecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static class Identity {
        @CommandLine.Option(names={"-c", "--cert"}, description={"certificate store. Format keystore#hexstorepwd#hexkeypwd#alias or keystore.pem. If the private key is not contained, use '--private-key' to add it from a separate file."})
        public SslContextUtil.Credentials certificate;
        @CommandLine.Option(names={"--private-key"}, description={"private key store. Format keystore#hexstorepwd#hexkeypwd#alias or keystore.pem"})
        public SslContextUtil.Credentials privateKey;
    }

    public static class Authentication {
        public SslContextUtil.Credentials credentials;
        @CommandLine.ArgGroup(exclusive=false)
        public Identity identity;
        @CommandLine.Option(names={"--anonymous"}, description={"anonymous, no certificate."})
        public boolean anonymous;

        public void defaults() {
            if (!this.anonymous) {
                if (this.identity.certificate == null) {
                    LOGGER.info("x509 identity from private key.");
                    this.credentials = this.identity.privateKey;
                } else if (this.identity.certificate.getPrivateKey() == null) {
                    LOGGER.info("x509 identity from certificate and private key.");
                    this.credentials = new SslContextUtil.Credentials(this.identity.privateKey.getPrivateKey(), this.identity.certificate.getPublicKey(), this.identity.certificate.getCertificateChain());
                } else {
                    LOGGER.info("x509 identity from certificate.");
                    this.credentials = this.identity.certificate;
                }
                if (this.credentials.getPrivateKey() == null) {
                    throw new IllegalArgumentException("Missing private key!");
                }
                if (this.credentials.getPublicKey() == null) {
                    throw new IllegalArgumentException("Missing public key or certificate!");
                }
            }
        }

        public void defaults(String defaultEcCredentials) {
            if (!this.anonymous && this.identity == null) {
                try {
                    this.identity = new Identity();
                    this.identity.certificate = SslContextUtil.loadCredentials((String)defaultEcCredentials);
                    LOGGER.info("x509 default identity.");
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.defaults();
        }
    }

    private static class TrustedCertificates {
        private final Certificate[] trusts;

        private TrustedCertificates(Certificate[] trusts) {
            this.trusts = trusts;
        }
    }

    public static enum AuthenticationMode {
        NONE,
        PSK,
        RPK,
        X509,
        ECDHE_PSK;

    }
}

