/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli.tcp.netty;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.eclipse.californium.cli.CliConnectorFactory;
import org.eclipse.californium.cli.ClientBaseConfig;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.tcp.netty.TlsClientConnector;
import org.eclipse.californium.elements.util.SslContextUtil;

public class TlsConnectorFactory
implements CliConnectorFactory {
    private static final String ALIAS = "client";

    public Connector create(ClientBaseConfig clientConfig, ExecutorService executor) {
        NetworkConfig config = clientConfig.networkConfig;
        int tcpThreads = config.getInt("TCP_WORKER_THREADS");
        int tcpConnectTimeout = config.getInt("TCP_CONNECT_TIMEOUT");
        int tlsHandshakeTimeout = config.getInt("TLS_HANDSHAKE_TIMEOUT");
        int tcpIdleTimeout = config.getInt("TCP_CONNECTION_IDLE_TIMEOUT");
        int maxPeers = config.getInt("MAX_ACTIVE_PEERS");
        int sessionTimeout = config.getInt("SECURE_SESSION_TIMEOUT");
        SSLContext clientSslContext = null;
        try {
            KeyManager[] keyManager = clientConfig.authentication.anonymous ? SslContextUtil.createAnonymousKeyManager() : SslContextUtil.createKeyManager((String)ALIAS, (PrivateKey)clientConfig.authentication.credentials.getPrivateKey(), (X509Certificate[])clientConfig.authentication.credentials.getCertificateChain());
            TrustManager[] trustManager = clientConfig.trust.trustall ? SslContextUtil.createTrustAllManager() : SslContextUtil.createTrustManager((String)ALIAS, (Certificate[])clientConfig.trust.trusts);
            clientSslContext = SSLContext.getInstance("TLSv1.2");
            clientSslContext.init(keyManager, trustManager, null);
            SSLSessionContext clientSessionContext = clientSslContext.getClientSessionContext();
            if (clientSessionContext != null) {
                clientSessionContext.setSessionTimeout(sessionTimeout);
                clientSessionContext.setSessionCacheSize(maxPeers);
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return new TlsClientConnector(clientSslContext, tcpThreads, tcpConnectTimeout, tlsHandshakeTimeout, tcpIdleTimeout);
    }
}

