/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.impl;

import org.eclipse.aether.internal.test.util.impl.StubVersion;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestVersionRange
implements VersionRange {
    private final Version lowerBound;
    private final boolean lowerBoundInclusive;
    private final Version upperBound;
    private final boolean upperBoundInclusive;

    public TestVersionRange(String range) throws InvalidVersionSpecificationException {
        String process = range;
        if (range.startsWith("[")) {
            this.lowerBoundInclusive = true;
        } else if (range.startsWith("(")) {
            this.lowerBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", a range must start with either [ or (");
        }
        if (range.endsWith("]")) {
            this.upperBoundInclusive = true;
        } else if (range.endsWith(")")) {
            this.upperBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", a range must end with either [ or (");
        }
        process = process.substring(1, process.length() - 1);
        int index = process.indexOf(",");
        if (index < 0) {
            if (!this.lowerBoundInclusive || !this.upperBoundInclusive) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", single version must be surrounded by []");
            }
            this.lowerBound = this.upperBound = new StubVersion(process.trim());
        } else {
            String parsedLowerBound = process.substring(0, index).trim();
            String parsedUpperBound = process.substring(index + 1).trim();
            if (parsedUpperBound.contains(",")) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", bounds may not contain additional ','");
            }
            this.lowerBound = parsedLowerBound.length() > 0 ? new StubVersion(parsedLowerBound) : null;
            StubVersion stubVersion = this.upperBound = parsedUpperBound.length() > 0 ? new StubVersion(parsedUpperBound) : null;
            if (this.upperBound != null && this.lowerBound != null && this.upperBound.compareTo((Object)this.lowerBound) < 0) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", lower bound must not be greater than upper bound");
            }
        }
    }

    public TestVersionRange(Version lowerBound, boolean lowerBoundInclusive, Version upperBound, boolean upperBoundInclusive) {
        this.lowerBound = lowerBound;
        this.lowerBoundInclusive = lowerBoundInclusive;
        this.upperBound = upperBound;
        this.upperBoundInclusive = upperBoundInclusive;
    }

    public Version getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerBoundInclusive() {
        return this.lowerBoundInclusive;
    }

    public Version getUpperBound() {
        return this.upperBound;
    }

    public boolean isUpperBoundInclusive() {
        return this.upperBoundInclusive;
    }

    public boolean acceptsSnapshots() {
        return this.isSnapshot(this.lowerBound) || this.isSnapshot(this.upperBound);
    }

    public boolean containsVersion(Version version) {
        int comparison;
        boolean snapshot = this.isSnapshot(version);
        if (this.lowerBound != null) {
            comparison = this.lowerBound.compareTo((Object)version);
            if (snapshot && comparison == 0) {
                return true;
            }
            if (comparison == 0 && !this.lowerBoundInclusive) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.compareTo((Object)version);
            if (snapshot && comparison == 0) {
                return true;
            }
            if (comparison == 0 && !this.upperBoundInclusive) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        if (this.lowerBound != null || this.upperBound != null) {
            return !snapshot;
        }
        return true;
    }

    private boolean isSnapshot(Version version) {
        return version != null && version.toString().endsWith("SNAPSHOT");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TestVersionRange that = (TestVersionRange)obj;
        return this.upperBoundInclusive == that.upperBoundInclusive && this.lowerBoundInclusive == that.lowerBoundInclusive && TestVersionRange.eq(this.upperBound, that.upperBound) && TestVersionRange.eq(this.lowerBound, that.lowerBound);
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + TestVersionRange.hash(this.upperBound);
        hash = hash * 31 + (this.upperBoundInclusive ? 1 : 0);
        hash = hash * 31 + TestVersionRange.hash(this.lowerBound);
        hash = hash * 31 + (this.lowerBoundInclusive ? 1 : 0);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(this.lowerBoundInclusive ? (char)'[' : '(');
        if (this.lowerBound != null) {
            buffer.append(this.lowerBound);
        }
        buffer.append(',');
        if (this.upperBound != null) {
            buffer.append(this.upperBound);
        }
        buffer.append(this.upperBoundInclusive ? (char)']' : ')');
        return buffer.toString();
    }
}

