/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordingRepositoryListener
implements RepositoryListener {
    private List<EventWrapper> events = Collections.synchronizedList(new ArrayList());
    private RepositoryListener realListener;

    public RecordingRepositoryListener() {
        this(null);
    }

    public RecordingRepositoryListener(RepositoryListener listener) {
        this.realListener = listener;
    }

    public List<EventWrapper> getEvents() {
        return this.events;
    }

    public void clear() {
        this.events.clear();
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        Type type = Type.ARTIFACT_DESCRIPTOR_INVALID;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.artifactDescriptorInvalid(event);
        }
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        Type type = Type.ARTIFACT_DESCRIPTOR_MISSING;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.artifactDescriptorMissing(event);
        }
    }

    public void metadataInvalid(RepositoryEvent event) {
        Type type = Type.METADATA_INVALID;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.metadataInvalid(event);
        }
    }

    public void artifactResolving(RepositoryEvent event) {
        Type type = Type.ARTIFACT_RESOLVING;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.artifactResolving(event);
        }
    }

    public void artifactResolved(RepositoryEvent event) {
        Type type = Type.ARTIFACT_RESOLVED;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.artifactResolved(event);
        }
    }

    public void artifactDownloading(RepositoryEvent event) {
    }

    public void artifactDownloaded(RepositoryEvent event) {
    }

    public void metadataDownloaded(RepositoryEvent event) {
    }

    public void metadataDownloading(RepositoryEvent event) {
    }

    public void metadataResolving(RepositoryEvent event) {
        Type type = Type.METADATA_RESOLVING;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.metadataResolving(event);
        }
    }

    public void metadataResolved(RepositoryEvent event) {
        Type type = Type.METADATA_RESOLVED;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.metadataResolved(event);
        }
    }

    public void artifactInstalling(RepositoryEvent event) {
        Type type = Type.ARTIFACT_INSTALLING;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.artifactInstalling(event);
        }
    }

    public void artifactInstalled(RepositoryEvent event) {
        Type type = Type.ARTIFACT_INSTALLED;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.artifactInstalled(event);
        }
    }

    public void metadataInstalling(RepositoryEvent event) {
        Type type = Type.METADATA_INSTALLING;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.metadataInstalling(event);
        }
    }

    public void metadataInstalled(RepositoryEvent event) {
        Type type = Type.METADATA_INSTALLED;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.metadataInstalled(event);
        }
    }

    public void artifactDeploying(RepositoryEvent event) {
        Type type = Type.ARTIFACT_DEPLOYING;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.artifactDeploying(event);
        }
    }

    public void artifactDeployed(RepositoryEvent event) {
        Type type = Type.ARTIFACT_DEPLOYED;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.artifactDeployed(event);
        }
    }

    public void metadataDeploying(RepositoryEvent event) {
        Type type = Type.METADATA_DEPLOYING;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.metadataDeploying(event);
        }
    }

    public void metadataDeployed(RepositoryEvent event) {
        Type type = Type.METADATA_DEPLOYED;
        this.events.add(new EventWrapper(type, event));
        if (this.realListener != null) {
            this.realListener.metadataDeployed(event);
        }
    }

    public class EventWrapper {
        Type type;
        RepositoryEvent event;

        public EventWrapper(Type type, RepositoryEvent event) {
            this.type = type;
            this.event = event;
        }

        public Type getType() {
            return this.type;
        }

        public RepositoryEvent getEvent() {
            return this.event;
        }

        public String toString() {
            Exception item = this.event.getException();
            item = item == null ? this.event.getArtifact() : item;
            item = item == null ? this.event.getMetadata() : item;
            return this.type.toString() + " (" + item + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        METADATA_DEPLOYED,
        METADATA_DEPLOYING,
        ARTIFACT_DEPLOYED,
        ARTIFACT_DEPLOYING,
        METADATA_INSTALLED,
        METADATA_INSTALLING,
        ARTIFACT_INSTALLED,
        ARTIFACT_INSTALLING,
        METADATA_RESOLVED,
        METADATA_RESOLVING,
        ARTIFACT_RESOLVED,
        ARTIFACT_RESOLVING,
        METADATA_INVALID,
        ARTIFACT_DESCRIPTOR_MISSING,
        ARTIFACT_DESCRIPTOR_INVALID;

    }
}

