/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Component(role=RepositoryConnectorProvider.class)
public class DefaultRepositoryConnectorProvider
implements RepositoryConnectorProvider,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement(role=RepositoryConnectorFactory.class)
    private Collection<RepositoryConnectorFactory> connectorFactories = new ArrayList<RepositoryConnectorFactory>();
    private static final Comparator<RepositoryConnectorFactory> COMPARATOR = new Comparator<RepositoryConnectorFactory>(){

        @Override
        public int compare(RepositoryConnectorFactory o1, RepositoryConnectorFactory o2) {
            return Float.compare(o2.getPriority(), o1.getPriority());
        }
    };

    public DefaultRepositoryConnectorProvider() {
    }

    @Inject
    DefaultRepositoryConnectorProvider(Set<RepositoryConnectorFactory> connectorFactories, LoggerFactory loggerFactory) {
        this.setRepositoryConnectorFactories(connectorFactories);
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.connectorFactories = locator.getServices(RepositoryConnectorFactory.class);
    }

    public DefaultRepositoryConnectorProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultRepositoryConnectorProvider addRepositoryConnectorFactory(RepositoryConnectorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("repository connector factory has not been specified");
        }
        this.connectorFactories.add(factory);
        return this;
    }

    public DefaultRepositoryConnectorProvider setRepositoryConnectorFactories(Collection<RepositoryConnectorFactory> factories) {
        this.connectorFactories = factories == null ? new ArrayList<RepositoryConnectorFactory>() : factories;
        return this;
    }

    DefaultRepositoryConnectorProvider setConnectorFactories(List<RepositoryConnectorFactory> factories) {
        return this.setRepositoryConnectorFactories(factories);
    }

    @Override
    public RepositoryConnector newRepositoryConnector(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        if (repository == null) {
            throw new IllegalArgumentException("remote repository has not been specified");
        }
        ArrayList<RepositoryConnectorFactory> factories = new ArrayList<RepositoryConnectorFactory>(this.connectorFactories);
        Collections.sort(factories, COMPARATOR);
        ArrayList<NoRepositoryConnectorException> errors = new ArrayList<NoRepositoryConnectorException>();
        for (RepositoryConnectorFactory factory : factories) {
            try {
                RepositoryConnector repositoryConnector = factory.newInstance(session, repository);
                if (this.logger.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(repositoryConnector.getClass().getSimpleName());
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    this.logger.debug(buffer.toString());
                }
                return repositoryConnector;
            }
            catch (NoRepositoryConnectorException noRepositoryConnectorException) {
                errors.add(noRepositoryConnectorException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain connector factory for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, (Throwable)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No connector factories available");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available connector factories: ");
            ListIterator it = factories.listIterator();
            while (it.hasNext()) {
                RepositoryConnectorFactory repositoryConnectorFactory = (RepositoryConnectorFactory)it.next();
                buffer.append(repositoryConnectorFactory.getClass().getSimpleName());
                if (!it.hasNext()) continue;
                buffer.append(", ");
            }
        }
        throw new NoRepositoryConnectorException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryConnectorException)((Object)errors.get(0)) : null);
    }
}

