/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.SafeTransferListener;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Component(role=ArtifactResolver.class)
public class DefaultArtifactResolver
implements ArtifactResolver,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private FileProcessor fileProcessor;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private VersionResolver versionResolver;
    @Requirement
    private UpdateCheckManager updateCheckManager;
    @Requirement
    private RepositoryConnectorProvider repositoryConnectorProvider;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private SyncContextFactory syncContextFactory;
    @Requirement
    private OfflineController offlineController;

    public DefaultArtifactResolver() {
    }

    @Inject
    DefaultArtifactResolver(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController, LoggerFactory loggerFactory) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setVersionResolver(versionResolver);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setFileProcessor((FileProcessor)locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher((RepositoryEventDispatcher)locator.getService(RepositoryEventDispatcher.class));
        this.setVersionResolver((VersionResolver)locator.getService(VersionResolver.class));
        this.setUpdateCheckManager((UpdateCheckManager)locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider((RepositoryConnectorProvider)locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager((RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory((SyncContextFactory)locator.getService(SyncContextFactory.class));
        this.setOfflineController((OfflineController)locator.getService(OfflineController.class));
    }

    public DefaultArtifactResolver setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultArtifactResolver setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public DefaultArtifactResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultArtifactResolver setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultArtifactResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        if (updateCheckManager == null) {
            throw new IllegalArgumentException("update check manager has not been specified");
        }
        this.updateCheckManager = updateCheckManager;
        return this;
    }

    public DefaultArtifactResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        if (repositoryConnectorProvider == null) {
            throw new IllegalArgumentException("repository connector provider has not been specified");
        }
        this.repositoryConnectorProvider = repositoryConnectorProvider;
        return this;
    }

    public DefaultArtifactResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public DefaultArtifactResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    public DefaultArtifactResolver setOfflineController(OfflineController offlineController) {
        if (offlineController == null) {
            throw new IllegalArgumentException("offline controller has not been specified");
        }
        this.offlineController = offlineController;
        return this;
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.resolveArtifacts(session, Collections.singleton(request)).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        SyncContext syncContext = this.syncContextFactory.newInstance(session, false);
        try {
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(requests.size());
            for (ArtifactRequest artifactRequest : requests) {
                if (artifactRequest.getArtifact().getProperty("localPath", null) != null) continue;
                artifacts.add(artifactRequest.getArtifact());
            }
            syncContext.acquire(artifacts, null);
            List<ArtifactResult> list = this.resolve(session, requests);
            return list;
        }
        finally {
            syncContext.close();
        }
    }

    private List<ArtifactResult> resolve(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>(requests.size());
        boolean failures = false;
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        WorkspaceReader workspace = session.getWorkspaceReader();
        ArrayList<ResolutionGroup> groups = new ArrayList<ResolutionGroup>();
        for (ArtifactRequest artifactRequest : requests) {
            File file;
            VersionResult versionResult;
            RequestTrace trace = RequestTrace.newChild((RequestTrace)artifactRequest.getTrace(), (Object)artifactRequest);
            ArtifactResult result = new ArtifactResult(artifactRequest);
            results.add(result);
            Artifact artifact = artifactRequest.getArtifact();
            List<Object> repos = artifactRequest.getRepositories();
            this.artifactResolving(session, trace, artifact);
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null) {
                File file2 = new File(localPath);
                if (!file2.isFile()) {
                    failures = true;
                    result.addException((Exception)new ArtifactNotFoundException(artifact, null));
                    continue;
                }
                artifact = artifact.setFile(file2);
                result.setArtifact(artifact);
                this.artifactResolved(session, trace, artifact, null, result.getExceptions());
                continue;
            }
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, (List)repos, artifactRequest.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
            }
            catch (VersionResolutionException e) {
                result.addException((Exception)((Object)e));
                continue;
            }
            artifact = artifact.setVersion(versionResult.getVersion());
            if (versionResult.getRepository() != null) {
                repos = versionResult.getRepository() instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)versionResult.getRepository()) : Collections.emptyList();
            }
            if (workspace != null && (file = workspace.findArtifact(artifact)) != null) {
                artifact = artifact.setFile(file);
                result.setArtifact(artifact);
                result.setRepository((ArtifactRepository)workspace.getRepository());
                this.artifactResolved(session, trace, artifact, result.getRepository(), null);
                continue;
            }
            LocalArtifactResult local = lrm.find(session, new LocalArtifactRequest(artifact, repos, artifactRequest.getRequestContext()));
            if (this.isLocallyInstalled(local, versionResult)) {
                if (local.getRepository() != null) {
                    result.setRepository((ArtifactRepository)local.getRepository());
                } else {
                    result.setRepository((ArtifactRepository)lrm.getRepository());
                }
                try {
                    artifact = artifact.setFile(this.getFile(session, artifact, local.getFile()));
                    result.setArtifact(artifact);
                    this.artifactResolved(session, trace, artifact, result.getRepository(), null);
                }
                catch (ArtifactTransferException e) {
                    result.addException((Exception)((Object)e));
                }
                if (local.isAvailable()) continue;
                lrm.add(session, new LocalArtifactRegistration(artifact));
                continue;
            }
            if (local.getFile() != null) {
                this.logger.debug("Verifying availability of " + local.getFile() + " from " + repos);
            }
            AtomicBoolean resolved = new AtomicBoolean(false);
            Iterator<Object> groupIt = groups.iterator();
            for (RemoteRepository remoteRepository : repos) {
                if (!remoteRepository.getPolicy(artifact.isSnapshot()).isEnabled()) continue;
                try {
                    this.offlineController.checkOffline(session, remoteRepository);
                }
                catch (RepositoryOfflineException e) {
                    ArtifactNotFoundException exception = new ArtifactNotFoundException(artifact, remoteRepository, "Cannot access " + remoteRepository.getId() + " (" + remoteRepository.getUrl() + ") in offline mode and the artifact " + artifact + " has not been downloaded from it before.", (Throwable)e);
                    result.addException((Exception)exception);
                    continue;
                }
                ResolutionGroup group = null;
                while (groupIt.hasNext()) {
                    ResolutionGroup t = (ResolutionGroup)groupIt.next();
                    if (!t.matches(remoteRepository)) continue;
                    group = t;
                    break;
                }
                if (group == null) {
                    group = new ResolutionGroup(remoteRepository);
                    groups.add(group);
                    groupIt = Collections.emptyList().iterator();
                }
                group.items.add(new ResolutionItem(trace, artifact, resolved, result, local, remoteRepository));
            }
        }
        for (ResolutionGroup resolutionGroup : groups) {
            this.performDownloads(session, resolutionGroup);
        }
        for (ArtifactResult artifactResult : results) {
            ArtifactRequest request = artifactResult.getRequest();
            Artifact artifact = artifactResult.getArtifact();
            if (artifact != null && artifact.getFile() != null) continue;
            failures = true;
            if (artifactResult.getExceptions().isEmpty()) {
                ArtifactNotFoundException exception = new ArtifactNotFoundException(request.getArtifact(), null);
                artifactResult.addException((Exception)exception);
            }
            RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
            this.artifactResolved(session, trace, request.getArtifact(), null, artifactResult.getExceptions());
        }
        if (failures) {
            throw new ArtifactResolutionException(results);
        }
        return results;
    }

    private boolean isLocallyInstalled(LocalArtifactResult lar, VersionResult vr) {
        if (lar.isAvailable()) {
            return true;
        }
        if (lar.getFile() != null) {
            if (vr.getRepository() instanceof LocalRepository) {
                return true;
            }
            if (vr.getRepository() == null && lar.getRequest().getRepositories().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private File getFile(RepositorySystemSession session, Artifact artifact, File file) throws ArtifactTransferException {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion()) && ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.artifactResolver.snapshotNormalization"})) {
            boolean copy;
            String name = file.getName().replace(artifact.getVersion(), artifact.getBaseVersion());
            File dst = new File(file.getParent(), name);
            boolean bl = copy = dst.length() != file.length() || dst.lastModified() != file.lastModified();
            if (copy) {
                try {
                    this.fileProcessor.copy(file, dst);
                    dst.setLastModified(file.lastModified());
                }
                catch (IOException e) {
                    throw new ArtifactTransferException(artifact, null, (Throwable)e);
                }
            }
            file = dst;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDownloads(RepositorySystemSession session, ResolutionGroup group) {
        List<ArtifactDownload> downloads = this.gatherDownloads(session, group);
        if (downloads.isEmpty()) {
            return;
        }
        for (ArtifactDownload download : downloads) {
            this.artifactDownloading(session, download.getTrace(), download.getArtifact(), group.repository);
        }
        try {
            RepositoryConnector connector = this.repositoryConnectorProvider.newRepositoryConnector(session, group.repository);
            try {
                connector.get(downloads, null);
            }
            finally {
                connector.close();
            }
        }
        catch (NoRepositoryConnectorException e) {
            for (ArtifactDownload download : downloads) {
                download.setException(new ArtifactTransferException(download.getArtifact(), group.repository, (Throwable)e));
            }
        }
        this.evaluateDownloads(session, group);
    }

    private List<ArtifactDownload> gatherDownloads(RepositorySystemSession session, ResolutionGroup group) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        ArrayList<ArtifactDownload> downloads = new ArrayList<ArtifactDownload>();
        for (ResolutionItem item : group.items) {
            Artifact artifact = item.artifact;
            if (item.resolved.get()) continue;
            ArtifactDownload download = new ArtifactDownload();
            download.setArtifact(artifact);
            download.setRequestContext(item.request.getRequestContext());
            download.setListener(SafeTransferListener.wrap(session, this.logger));
            download.setTrace(item.trace);
            if (item.local.getFile() != null) {
                download.setFile(item.local.getFile());
                download.setExistenceCheck(true);
            } else {
                String path = lrm.getPathForRemoteArtifact(artifact, group.repository, item.request.getRequestContext());
                download.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
            boolean snapshot = artifact.isSnapshot();
            RepositoryPolicy policy = this.remoteRepositoryManager.getPolicy(session, group.repository, !snapshot, snapshot);
            int errorPolicy = Utils.getPolicy(session, artifact, group.repository);
            if ((errorPolicy & 3) != 0) {
                UpdateCheck<Artifact, ArtifactTransferException> check = new UpdateCheck<Artifact, ArtifactTransferException>();
                check.setItem(artifact);
                check.setFile(download.getFile());
                check.setFileValid(false);
                check.setRepository(group.repository);
                check.setPolicy(policy.getUpdatePolicy());
                item.updateCheck = check;
                this.updateCheckManager.checkArtifact(session, check);
                if (!check.isRequired()) {
                    item.result.addException((Exception)((Object)check.getException()));
                    continue;
                }
            }
            download.setChecksumPolicy(policy.getChecksumPolicy());
            download.setRepositories(item.repository.getMirroredRepositories());
            downloads.add(download);
            item.download = download;
        }
        return downloads;
    }

    private void evaluateDownloads(RepositorySystemSession session, ResolutionGroup group) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        for (ResolutionItem item : group.items) {
            ArtifactDownload download = item.download;
            if (download == null) continue;
            Artifact artifact = download.getArtifact();
            if (download.getException() == null) {
                item.resolved.set(true);
                item.result.setRepository((ArtifactRepository)group.repository);
                try {
                    artifact = artifact.setFile(this.getFile(session, artifact, download.getFile()));
                    item.result.setArtifact(artifact);
                    lrm.add(session, new LocalArtifactRegistration(artifact, group.repository, download.getSupportedContexts()));
                }
                catch (ArtifactTransferException e) {
                    download.setException(e);
                    item.result.addException((Exception)((Object)e));
                }
            } else {
                item.result.addException((Exception)((Object)download.getException()));
            }
            if (item.updateCheck != null) {
                item.updateCheck.setException(download.getException());
                this.updateCheckManager.touchArtifact(session, item.updateCheck);
            }
            this.artifactDownloaded(session, download.getTrace(), artifact, group.repository, (Exception)((Object)download.getException()));
            if (download.getException() != null) continue;
            this.artifactResolved(session, download.getTrace(), artifact, (ArtifactRepository)group.repository, null);
        }
    }

    private void artifactResolving(RepositorySystemSession session, RequestTrace trace, Artifact artifact) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_RESOLVING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactResolved(RepositorySystemSession session, RequestTrace trace, Artifact artifact, ArtifactRepository repository, List<Exception> exceptions) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_RESOLVED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setExceptions(exceptions);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloading(RepositorySystemSession session, RequestTrace trace, Artifact artifact, RemoteRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DOWNLOADING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository((ArtifactRepository)repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloaded(RepositorySystemSession session, RequestTrace trace, Artifact artifact, RemoteRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DOWNLOADED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository((ArtifactRepository)repository);
        event.setException(exception);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    static class ResolutionItem {
        final RequestTrace trace;
        final ArtifactRequest request;
        final ArtifactResult result;
        final LocalArtifactResult local;
        final RemoteRepository repository;
        final Artifact artifact;
        final AtomicBoolean resolved;
        ArtifactDownload download;
        UpdateCheck<Artifact, ArtifactTransferException> updateCheck;

        ResolutionItem(RequestTrace trace, Artifact artifact, AtomicBoolean resolved, ArtifactResult result, LocalArtifactResult local, RemoteRepository repository) {
            this.trace = trace;
            this.artifact = artifact;
            this.resolved = resolved;
            this.result = result;
            this.request = result.getRequest();
            this.local = local;
            this.repository = repository;
        }
    }

    static class ResolutionGroup {
        final RemoteRepository repository;
        final List<ResolutionItem> items = new ArrayList<ResolutionItem>();

        ResolutionGroup(RemoteRepository repository) {
            this.repository = repository;
        }

        boolean matches(RemoteRepository repo) {
            return this.repository.getUrl().equals(repo.getUrl()) && this.repository.getContentType().equals(repo.getContentType()) && this.repository.isRepositoryManager() == repo.isRepositoryManager();
        }
    }
}

