/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.file;

import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.file.FileRepositoryConnector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;

@Named
@Component(role=RepositoryConnectorFactory.class, hint="file")
public final class FileRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private FileProcessor fileProcessor;
    private float priority = 1.0f;
    static final String CFG_PREFIX = "aether.connector.file";

    public FileRepositoryConnectorFactory() {
    }

    @Inject
    FileRepositoryConnectorFactory(FileProcessor fileProcessor, LoggerFactory loggerFactory) {
        this.setFileProcessor(fileProcessor);
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setFileProcessor((FileProcessor)locator.getService(FileProcessor.class));
    }

    public FileRepositoryConnectorFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, FileRepositoryConnector.class);
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public FileRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        if ("file".equalsIgnoreCase(repository.getProtocol())) {
            FileRepositoryConnector connector = new FileRepositoryConnector(session, repository, this.fileProcessor, this.logger);
            return connector;
        }
        throw new NoRepositoryConnectorException(repository);
    }

    public float getPriority() {
        return this.priority;
    }

    public FileRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

