/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.tasks;

import org.apache.tools.ant.Task;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;

class DependencyGraphLogger
implements DependencyVisitor {
    private Task task;
    private String indent = "";

    public DependencyGraphLogger(Task task) {
        this.task = task;
    }

    public boolean visitEnter(DependencyNode node) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.indent);
        Dependency dep = node.getDependency();
        if (dep != null) {
            String premanagedVersion;
            Artifact art = dep.getArtifact();
            buffer.append(art);
            buffer.append(':').append(dep.getScope());
            String premanagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)node);
            if (premanagedScope != null && !premanagedScope.equals(dep.getScope())) {
                buffer.append(" (scope managed from ").append(premanagedScope).append(")");
            }
            if ((premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node)) != null && !premanagedVersion.equals(art.getVersion())) {
                buffer.append(" (version managed from ").append(premanagedVersion).append(")");
            }
        } else {
            buffer.append("Resolved Dependency Graph:");
        }
        this.task.log(buffer.toString(), 3);
        this.indent = this.indent + "   ";
        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        this.indent = this.indent.substring(0, this.indent.length() - 3);
        return true;
    }
}

