/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.internal.ant.types.RemoteRepository;
import org.eclipse.aether.internal.ant.types.RemoteRepositoryContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRepositories
extends DataType
implements RemoteRepositoryContainer {
    private List<RemoteRepositoryContainer> containers = new ArrayList<RemoteRepositoryContainer>();

    protected RemoteRepositories getRef() {
        return (RemoteRepositories)this.getCheckedRef();
    }

    @Override
    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else {
            for (RemoteRepositoryContainer container : this.containers) {
                container.validate(task);
            }
        }
    }

    public void setRefid(Reference ref) {
        if (!this.containers.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public void addRemoterepo(RemoteRepository repository) {
        this.checkChildrenAllowed();
        this.containers.add(repository);
    }

    public void addRemoterepos(RemoteRepositories repositories) {
        this.checkChildrenAllowed();
        if (repositories == this) {
            throw this.circularReference();
        }
        this.containers.add(repositories);
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        if (this.isReference()) {
            return this.getRef().getRepositories();
        }
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (RemoteRepositoryContainer container : this.containers) {
            repos.addAll(container.getRepositories());
        }
        return repos;
    }
}

