/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.types;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.internal.ant.types.Dependency;
import org.eclipse.aether.internal.ant.types.DependencyContainer;
import org.eclipse.aether.internal.ant.types.Exclusion;
import org.eclipse.aether.internal.ant.types.Pom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dependencies
extends DataType
implements DependencyContainer {
    private File file;
    private Pom pom;
    private List<DependencyContainer> containers = new ArrayList<DependencyContainer>();
    private List<Exclusion> exclusions = new ArrayList<Exclusion>();
    private boolean nestedDependencies;

    protected Dependencies getRef() {
        return (Dependencies)this.getCheckedRef();
    }

    @Override
    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else {
            if (this.getPom() != null && this.getPom().getFile() == null) {
                throw new BuildException("A <pom> used for dependency resolution has to be backed by a pom.xml file");
            }
            HashMap<String, String> ids = new HashMap<String, String>();
            for (DependencyContainer container : this.containers) {
                Dependency dependency;
                String id;
                String collision;
                container.validate(task);
                if (!(container instanceof Dependency) || (collision = ids.put(id = (dependency = (Dependency)container).getVersionlessKey(), dependency.getVersion())) == null) continue;
                throw new BuildException("You must not declare multiple <dependency> elements with the same coordinates but got " + id + " -> " + collision + " vs " + dependency.getVersion());
            }
        }
    }

    public void setRefid(Reference ref) {
        if (this.pom != null || !this.exclusions.isEmpty() || !this.containers.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public void setFile(File file) {
        this.checkAttributesAllowed();
        this.file = file;
        this.checkExternalSources();
    }

    public File getFile() {
        if (this.isReference()) {
            return this.getRef().getFile();
        }
        return this.file;
    }

    public void addPom(Pom pom) {
        this.checkChildrenAllowed();
        if (this.pom != null) {
            throw new BuildException("You must not specify multiple <pom> elements");
        }
        this.pom = pom;
        this.checkExternalSources();
    }

    public Pom getPom() {
        if (this.isReference()) {
            return this.getRef().getPom();
        }
        return this.pom;
    }

    public void setPomRef(Reference ref) {
        if (this.pom == null) {
            this.pom = new Pom();
            this.pom.setProject(this.getProject());
        }
        this.pom.setRefid(ref);
        this.checkExternalSources();
    }

    private void checkExternalSources() {
        if (this.file != null && this.pom != null) {
            throw new BuildException("You must not specify both a text file and a POM to list dependencies");
        }
        if ((this.file != null || this.pom != null) && this.nestedDependencies) {
            throw new BuildException("You must not specify both a file/POM and nested dependency collections");
        }
    }

    public void addDependency(Dependency dependency) {
        this.checkChildrenAllowed();
        this.containers.add(dependency);
    }

    public void addDependencies(Dependencies dependencies) {
        this.checkChildrenAllowed();
        if (dependencies == this) {
            throw this.circularReference();
        }
        this.containers.add(dependencies);
        this.nestedDependencies = true;
        this.checkExternalSources();
    }

    public List<DependencyContainer> getDependencyContainers() {
        if (this.isReference()) {
            return this.getRef().getDependencyContainers();
        }
        return this.containers;
    }

    public void addExclusion(Exclusion exclusion) {
        this.checkChildrenAllowed();
        this.exclusions.add(exclusion);
    }

    public List<Exclusion> getExclusions() {
        if (this.isReference()) {
            return this.getRef().getExclusions();
        }
        return this.exclusions;
    }
}

