/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.types;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.internal.ant.ProjectWorkspaceReader;
import org.eclipse.aether.internal.ant.tasks.RefTask;
import org.eclipse.aether.internal.ant.types.ArtifactContainer;
import org.eclipse.aether.internal.ant.types.Pom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artifact
extends RefTask
implements ArtifactContainer {
    private File file;
    private String type;
    private String classifier;
    private Pom pom;

    protected Artifact getRef() {
        return (Artifact)this.getCheckedRef();
    }

    @Override
    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else {
            if (this.file == null) {
                throw new BuildException("You must specify the 'file' for the artifact");
            }
            if (!this.file.isFile()) {
                throw new BuildException("The artifact file " + this.file + " does not exist");
            }
            if (this.type == null || this.type.length() <= 0) {
                throw new BuildException("You must specify the 'type' for the artifact");
            }
        }
    }

    @Override
    public void setRefid(Reference ref) {
        if (this.file != null || this.type != null || this.classifier != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(ref);
    }

    public File getFile() {
        if (this.isReference()) {
            return this.getRef().getFile();
        }
        return this.file;
    }

    public void setFile(File file) {
        String name;
        int period;
        this.checkAttributesAllowed();
        this.file = file;
        if (file != null && this.type == null && (period = (name = file.getName()).lastIndexOf(46)) >= 0) {
            this.type = name.substring(period + 1);
        }
    }

    public String getType() {
        if (this.isReference()) {
            return this.getRef().getType();
        }
        return this.type != null ? this.type : "jar";
    }

    public void setType(String type) {
        this.checkAttributesAllowed();
        this.type = type;
    }

    public String getClassifier() {
        if (this.isReference()) {
            return this.getRef().getClassifier();
        }
        return this.classifier != null ? this.classifier : "";
    }

    public void setClassifier(String classifier) {
        this.checkAttributesAllowed();
        this.classifier = classifier;
    }

    public void setPomRef(Reference ref) {
        this.checkAttributesAllowed();
        Pom pom = new Pom();
        pom.setProject(this.getProject());
        pom.setRefid(ref);
        this.pom = pom;
    }

    public void addPom(Pom pom) {
        this.checkChildrenAllowed();
        this.pom = pom;
    }

    public Pom getPom() {
        if (this.isReference()) {
            return this.getRef().getPom();
        }
        return this.pom;
    }

    @Override
    public List<Artifact> getArtifacts() {
        return Collections.singletonList(this);
    }

    public void execute() throws BuildException {
        ProjectWorkspaceReader.getInstance().addArtifact(this);
    }

    public String toString() {
        String pomRepr = this.getPom() != null ? "(" + this.getPom().toString() + ":)" : "";
        return String.format(pomRepr + "%s:%s", this.getType(), this.getClassifier());
    }
}

