/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.ant.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.ant.types.Dependency;
import org.eclipse.aether.ant.types.Exclusion;
import org.eclipse.aether.ant.types.RemoteRepositories;
import org.eclipse.aether.ant.types.RemoteRepository;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterUtils {
    private static Artifact toArtifact(Dependency dependency, ArtifactTypeRegistry types) {
        ArtifactType type = types.get(dependency.getType());
        if (type == null) {
            type = new DefaultArtifactType(dependency.getType());
        }
        Map<String, String> props = null;
        if ("system".equals(dependency.getScope()) && dependency.getSystemPath() != null) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath().getPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, type);
        return artifact;
    }

    public static Authentication toAuthentication(org.eclipse.aether.ant.types.Authentication auth) {
        if (auth == null) {
            return null;
        }
        AuthenticationBuilder authBuilder = new AuthenticationBuilder();
        authBuilder.addUsername(auth.getUsername()).addPassword(auth.getPassword());
        authBuilder.addPrivateKey(auth.getPrivateKeyFile(), auth.getPassphrase());
        return authBuilder.build();
    }

    public static org.eclipse.aether.graph.Dependency toDependency(Dependency dependency, List<Exclusion> exclusions, RepositorySystemSession session) {
        return new org.eclipse.aether.graph.Dependency(ConverterUtils.toArtifact(dependency, session.getArtifactTypeRegistry()), dependency.getScope(), Boolean.valueOf(false), ConverterUtils.toExclusions(dependency.getExclusions(), exclusions));
    }

    public static RemoteRepository toDistRepository(org.eclipse.aether.ant.types.RemoteRepository repo, RepositorySystemSession session) {
        RemoteRepository result = ConverterUtils.toRepository(repo);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(result);
        builder.setAuthentication(session.getAuthenticationSelector().getAuthentication(result));
        builder.setProxy(session.getProxySelector().getProxy(result));
        return builder.build();
    }

    private static org.eclipse.aether.graph.Exclusion toExclusion(Exclusion exclusion) {
        return new org.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), exclusion.getClassifier(), exclusion.getExtension());
    }

    private static Collection<org.eclipse.aether.graph.Exclusion> toExclusions(Collection<Exclusion> exclusions1, Collection<Exclusion> exclusions2) {
        LinkedHashSet<org.eclipse.aether.graph.Exclusion> results = new LinkedHashSet<org.eclipse.aether.graph.Exclusion>();
        if (exclusions1 != null) {
            for (Exclusion exclusion : exclusions1) {
                results.add(ConverterUtils.toExclusion(exclusion));
            }
        }
        if (exclusions2 != null) {
            for (Exclusion exclusion : exclusions2) {
                results.add(ConverterUtils.toExclusion(exclusion));
            }
        }
        return results;
    }

    private static RepositoryPolicy toPolicy(RemoteRepository.Policy policy, boolean enabled, String updates, String checksums) {
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getChecksums() != null) {
                checksums = policy.getChecksums();
            }
            if (policy.getUpdates() != null) {
                updates = policy.getUpdates();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    public static Properties addProperties(Properties props, Map<?, ?> map) {
        if (props == null) {
            props = new Properties();
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            props.put(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public static Proxy toProxy(org.eclipse.aether.ant.types.Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        return new Proxy(proxy.getType(), proxy.getHost(), proxy.getPort(), ConverterUtils.toAuthentication(proxy.getAuthentication()));
    }

    private static RemoteRepository toRepository(org.eclipse.aether.ant.types.RemoteRepository repo) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), repo.getType(), repo.getUrl());
        builder.setSnapshotPolicy(ConverterUtils.toPolicy(repo.getSnapshotPolicy(), repo.isSnapshots(), repo.getUpdates(), repo.getChecksums()));
        builder.setReleasePolicy(ConverterUtils.toPolicy(repo.getReleasePolicy(), repo.isReleases(), repo.getUpdates(), repo.getChecksums()));
        builder.setAuthentication(ConverterUtils.toAuthentication(repo.getAuthentication()));
        return builder.build();
    }

    public static List<RemoteRepository> toRepositories(Project project, RepositorySystemSession session, RemoteRepositories repos, RemoteRepositoryManager remoteRepositoryManager) {
        List<org.eclipse.aether.ant.types.RemoteRepository> repositories = repos != null ? repos.getRepositories() : new ArrayList<org.eclipse.aether.ant.types.RemoteRepository>();
        ArrayList<RemoteRepository> results = new ArrayList<RemoteRepository>();
        for (org.eclipse.aether.ant.types.RemoteRepository repo : repositories) {
            results.add(ConverterUtils.toRepository(repo));
        }
        results = remoteRepositoryManager.aggregateRepositories(session, Collections.emptyList(), results, true);
        return results;
    }
}

