/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.util.Arrays;

final class ErrorMessages {
    static String unexpectedNotEqual(Object actual, Object expected) {
        return Formatting.format("expected:<%s> but was:<%s>", expected, actual);
    }

    static String unexpectedEqual(Object actual, Object o) {
        return ErrorMessages.assertionFailed(actual, " should not be equal to:", o);
    }

    static String unexpectedLessThanOrEqualTo(Object actual, Object value) {
        return ErrorMessages.assertionFailed(actual, " should be greater than:", value);
    }

    static String unexpectedLessThan(Object actual, Object value) {
        return ErrorMessages.assertionFailed(actual, " should be greater than or equal to:", value);
    }

    static String unexpectedGreaterThanOrEqualTo(Object actual, Object value) {
        return ErrorMessages.assertionFailed(actual, " should be less than:", value);
    }

    static String unexpectedGreaterThan(Object actual, Object value) {
        return ErrorMessages.assertionFailed(actual, " should be less than or equal to:", value);
    }

    static String unexpectedNullType(Description description) {
        return Formatting.createMessageFrom(description, Arrays.array((Object[])new String[]{"expected type should not be null"}));
    }

    private static String assertionFailed(Object actual, String reason, Object expected) {
        return ErrorMessages.assertionFailed(null, actual, reason, expected);
    }

    private static String assertionFailed(Description description, Object actual, String reason, Object expected) {
        return Formatting.createMessageFrom(description, Arrays.array((Object[])new String[]{"actual value:", Formatting.inBrackets(actual), reason, Formatting.inBrackets(expected)}));
    }

    static String unexpectedNotIn(String description, Object actual, Object other) {
        return ErrorMessages.assertionFailed(actual, " should be in:", other);
    }

    static String unexpectedIn(String description, Object actual, Object other) {
        return ErrorMessages.assertionFailed(actual, " should not be in:", other);
    }

    private ErrorMessages() {
    }
}

