/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.impl;

import java.io.IOException;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import org.easetech.easytest.annotation.Report;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.impl.ReportBuilder;
import org.easetech.easytest.reports.impl.ReportExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ReportRunner.class);
    private ReportBuilder reportBuilder;
    private ReportExporter reportExporter;
    private ReportDataContainer testReportContainer;

    public ReportRunner(ReportDataContainer testReportContainer) {
        this.testReportContainer = testReportContainer;
        this.reportBuilder = new ReportBuilder(testReportContainer);
        this.reportExporter = new ReportExporter();
    }

    public void runReports(Report.EXPORT_FORMAT[] formats, String destinationLocation) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        JRDataSource reportDataSource = this.reportBuilder.buildTestReport(reportParameters);
        String className = this.testReportContainer.getClassName();
        reportParameters.put("TEST_CLASS_NAME", className);
        try {
            this.reportExporter.printDefaultReport(reportDataSource, reportParameters, destinationLocation, className, formats);
        }
        catch (JRException e) {
            System.out.println((Object)e);
            LOG.error("JRException occurred during generation of report", (Throwable)e);
        }
        catch (IOException e) {
            System.out.println(e);
            LOG.error("IOException occurred during generation of report", (Throwable)e);
        }
    }
}

