/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.easetech.easytest.annotation.Report;
import org.easetech.easytest.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportExporter {
    private static final String DEFAULT_REPORT_JRXML = "/reports/MainReport.jrxml";

    public void printDefaultReport(JRDataSource dataSource, Map<String, Object> jasperParameters, String destinationFolder, String name, Report.EXPORT_FORMAT ... formats) throws JRException, IOException {
        JasperReport jasperReport = this.getJasperReport(DEFAULT_REPORT_JRXML);
        destinationFolder = CommonUtils.createDefaultOutputFolder(destinationFolder);
        String dateString = CommonUtils.getFormattedDate(new Date());
        this.exportReport(dataSource, jasperParameters, destinationFolder, name + "_" + dateString, jasperReport, formats);
    }

    private void exportReport(JRDataSource dataSource, Map<String, Object> jasperParameters, String destinationFolder, String reportName, JasperReport jasperReport, Report.EXPORT_FORMAT ... formats) throws JRException {
        JasperPrint jasperPrint = this.getJasperPrint(jasperReport, dataSource, jasperParameters);
        block5: for (Report.EXPORT_FORMAT export_FORMAT : formats) {
            switch (export_FORMAT) {
                case HTML: {
                    this.exportHTML(destinationFolder, reportName, jasperPrint);
                    continue block5;
                }
                case PDF: {
                    this.exportPDF(destinationFolder, reportName, jasperPrint);
                    continue block5;
                }
                case XLS: {
                    this.exportXLS(destinationFolder, reportName, jasperPrint);
                    continue block5;
                }
            }
        }
    }

    private JasperPrint getJasperPrint(JasperReport jasperReport, JRDataSource dataSource, Map<String, Object> jasperParameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, jasperParameters, (JRDataSource)dataSource);
        return jasperPrint;
    }

    private JasperReport getJasperReport(String reportResource) throws JRException {
        InputStream defaultReportInputStream = ClassLoader.class.getResourceAsStream(reportResource);
        JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)defaultReportInputStream);
        return jasperReport;
    }

    private void exportPDF(String destinationFolder, String reportName, JasperPrint jasperPrint) throws JRException {
        JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)(destinationFolder + File.separatorChar + reportName + "." + Report.EXPORT_FORMAT.PDF.toString().toLowerCase()));
    }

    private void exportHTML(String destinationFolder, String reportName, JasperPrint jasperPrint) throws JRException {
        JasperExportManager.exportReportToHtmlFile((JasperPrint)jasperPrint, (String)(destinationFolder + File.separatorChar + reportName + "." + Report.EXPORT_FORMAT.HTML.toString().toLowerCase()));
    }

    private void exportXLS(String destinationFolder, String reportName, JasperPrint jasperPrint) throws JRException {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(destinationFolder + File.separatorChar + reportName + "." + Report.EXPORT_FORMAT.XLS.toString().toLowerCase()));
        exporter.exportReport();
    }
}

