/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConverter {
    public static Map<String, List<Map<String, Object>>> convert(Map<String, List<Map<String, Object>>> from, Class<?> currentTestClass) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        for (String method : from.keySet()) {
            List<Map<String, Object>> value = from.get(method);
            for (Map<String, Object> singleTestMethod : value) {
                result.put(DataConverter.getFullyQualifiedTestName(method, currentTestClass).concat(singleTestMethod.toString()), Collections.singletonList(singleTestMethod));
            }
        }
        return result;
    }

    public static String getFullyQualifiedTestName(String testMethod, Class testClass) {
        return testClass == null ? testMethod : testClass.getName().concat(":").concat(testMethod);
    }

    public static String getTruncatedMethodName(String testMethod, Class testClass) {
        return testMethod.startsWith(testClass.getName()) ? testMethod.replaceAll(testClass.getName(), "") : testMethod;
    }

    public static Map<String, List<Map<String, Object>>> appendClassName(Map<String, List<Map<String, Object>>> from, Class<?> currentTestClass) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        for (String method : from.keySet()) {
            result.put(DataConverter.getFullyQualifiedTestName(method, currentTestClass), from.get(method));
        }
        return result;
    }
}

