/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.converter;

import java.util.HashSet;
import java.util.Set;
import org.easetech.easytest.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterManager {
    public static final ThreadLocal<Set<Converter>> converters = new ThreadLocal();

    public static Converter<?> findConverter(Class<?> targetType) {
        Set<Converter> cnvrtrs = converters.get();
        Converter result = null;
        if (cnvrtrs != null) {
            for (Converter converter : cnvrtrs) {
                if (!converter.convertTo().equals(targetType)) continue;
                result = converter;
                break;
            }
        }
        return result;
    }

    public static void registerConverter(Class converterClass) {
        Set<Converter> cnvrtrs = converters.get();
        if (cnvrtrs == null) {
            cnvrtrs = new HashSet<Converter>();
        }
        if (converterClass != null && Converter.class.isAssignableFrom(converterClass)) {
            Converter converter = null;
            try {
                converter = (Converter)converterClass.newInstance();
                cnvrtrs.add(converter);
                converters.set(cnvrtrs);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("InstantiationException occured while trying to register a converter with class : " + converterClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("IllegalAccessException occured while trying to register a converter with class : " + converterClass, e);
            }
        } else {
            System.out.println("Converter with class :" + converterClass + " not registered");
        }
    }

    public static void cleanConverters() {
        converters.remove();
    }
}

