/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.xml;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.duracloud.common.xml.error.XmlSerializationException;
import org.xml.sax.SAXException;

public class XmlSerializer<T> {
    private Class clazz;
    private String schemaName;
    private String schemaVersion;
    private JAXBContext context;
    private Schema schema;

    protected XmlSerializer(Class clazz, String schemaName, String schemaVersion) {
        this.clazz = clazz;
        this.schemaName = schemaName;
        this.schemaVersion = schemaVersion;
        try {
            this.context = JAXBContext.newInstance(clazz);
        }
        catch (JAXBException e) {
            throw new XmlSerializationException("Exception encountered creating serializer: " + this.getErrorMsg(e), e);
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaSource = new StreamSource(this.getClass().getClassLoader().getResourceAsStream(schemaName));
            this.schema = factory.newSchema(schemaSource);
        }
        catch (SAXException e) {
            throw new XmlSerializationException("Unable to load schema for validation due to: " + e.getMessage());
        }
    }

    public String serialize(T obj) {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", true);
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new XmlSerializationException("Exception encountered serializing report: " + this.getErrorMsg(e), e);
        }
    }

    public T deserialize(String xml) {
        if (xml == null || xml.equals("")) {
            throw new RuntimeException("XML cannot be null or empty");
        }
        return this.deserialize(new StreamSource(new StringReader(xml)));
    }

    public T deserialize(InputStream stream) {
        if (stream == null) {
            throw new RuntimeException("Stream cannot be null");
        }
        return this.deserialize(new StreamSource(stream));
    }

    private T deserialize(StreamSource stream) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            unmarshaller.setSchema(this.schema);
            JAXBElement report = unmarshaller.unmarshal(stream, this.clazz);
            return report.getValue();
        }
        catch (JAXBException e) {
            String error = "Exception encountered de-serializing xml using schema " + this.schemaName + " at version " + this.schemaVersion + ": " + this.getErrorMsg(e);
            throw new XmlSerializationException(error, e);
        }
    }

    private String getErrorMsg(Throwable error) {
        while (null != error && null == error.getMessage()) {
            error = error.getCause();
        }
        return error.getMessage();
    }
}

