/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.access.event.AbstractAuthorizationEvent;
import org.springframework.security.access.event.AuthenticationCredentialsNotFoundEvent;
import org.springframework.security.access.event.AuthorizationFailureEvent;
import org.springframework.security.access.event.AuthorizedEvent;
import org.springframework.security.access.event.PublicInvocationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerListener
implements ApplicationListener<AbstractAuthorizationEvent> {
    private static final Log logger = LogFactory.getLog(LoggerListener.class);

    @Override
    public void onApplicationEvent(AbstractAuthorizationEvent event) {
        AbstractAuthorizationEvent authEvent;
        if (event instanceof AuthenticationCredentialsNotFoundEvent) {
            authEvent = (AuthenticationCredentialsNotFoundEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn("Security interception failed due to: " + ((AuthenticationCredentialsNotFoundEvent)authEvent).getCredentialsNotFoundException() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + ((AuthenticationCredentialsNotFoundEvent)authEvent).getConfigAttributes());
            }
        }
        if (event instanceof AuthorizationFailureEvent) {
            authEvent = (AuthorizationFailureEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn("Security authorization failed due to: " + ((AuthorizationFailureEvent)authEvent).getAccessDeniedException() + "; authenticated principal: " + ((AuthorizationFailureEvent)authEvent).getAuthentication() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + ((AuthorizationFailureEvent)authEvent).getConfigAttributes());
            }
        }
        if (event instanceof AuthorizedEvent) {
            authEvent = (AuthorizedEvent)event;
            if (logger.isInfoEnabled()) {
                logger.info("Security authorized for authenticated principal: " + ((AuthorizedEvent)authEvent).getAuthentication() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + ((AuthorizedEvent)authEvent).getConfigAttributes());
            }
        }
        if (event instanceof PublicInvocationEvent) {
            authEvent = (PublicInvocationEvent)event;
            if (logger.isInfoEnabled()) {
                logger.info("Security interception not required for public secure object: " + authEvent.getSource());
            }
        }
    }
}

