/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.walker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.duracloud.sync.mgmt.ChangedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirWalker
extends DirectoryWalker
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(DirWalker.class);
    private static DirWalker dirWalker;
    private boolean continueWalk;
    private List<File> filesAndDirs;
    private WildcardFileFilter fileFilter;
    private ChangedList fileList;
    private int files = 0;
    private boolean complete = false;

    protected DirWalker(List<File> filesAndDirs, File excludeFile) {
        this.filesAndDirs = filesAndDirs;
        this.fileList = ChangedList.getInstance();
        if (null != excludeFile) {
            List<String> excludeList = this.readExcludeFile(excludeFile);
            this.setExcludeList(excludeList);
        }
    }

    private List<String> readExcludeFile(File excludeFile) {
        ArrayList<String> excludeList = new ArrayList<String>();
        try (BufferedReader excludeReader = new BufferedReader(new FileReader(excludeFile));){
            String excludeItem = excludeReader.readLine();
            while (excludeItem != null) {
                excludeList.add(excludeItem.trim());
                excludeItem = excludeReader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read exclude file " + excludeFile.getAbsolutePath() + " due to: " + e.getMessage());
        }
        return excludeList;
    }

    protected void setExcludeList(List<String> excludeList) {
        this.fileFilter = new WildcardFileFilter(excludeList, IOCase.INSENSITIVE);
    }

    @Override
    public void run() {
        this.walkDirs();
    }

    public void stopWalk() {
        this.continueWalk = false;
    }

    protected void walkDirs() {
        try {
            this.continueWalk = true;
            for (File item : this.filesAndDirs) {
                if (null != item && item.exists() && this.continueWalk) {
                    if (item.isDirectory()) {
                        try {
                            ArrayList results = new ArrayList();
                            this.walk(item, results);
                            continue;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error walking directory " + item.getAbsolutePath() + ":" + e.getMessage(), e);
                        }
                    }
                    this.handleFile(item, 0, (Collection)null);
                    continue;
                }
                String filename = "null";
                if (item != null) {
                    filename = item.getAbsolutePath();
                }
                this.logger.warn("Skipping " + filename + ", as it does not exist");
            }
            this.logger.info("Found " + this.files + " files to sync in initial directory walk");
        }
        catch (Exception e) {
            this.logger.error("dir walker failed: " + e.getMessage(), e);
        }
        this.complete = true;
    }

    protected void handleFile(File file, int depth, Collection results) {
        if (null == file) {
            this.logger.warn("The file parameter is unexpectedly null. Ignoring...");
        } else if (!this.excluded(file)) {
            ++this.files;
            this.fileList.addChangedFile(file);
        } else {
            this.logger.info("Skipping excluded file: " + file.getAbsolutePath());
        }
    }

    protected boolean excluded(File file) {
        if (null != this.fileFilter) {
            do {
                if (!this.fileFilter.accept(file)) continue;
                return true;
            } while ((file = file.getParentFile()) != null);
        }
        return false;
    }

    protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
        return !this.continueWalk;
    }

    public static DirWalker start(List<File> topDirs, File excludeFile) {
        dirWalker = new DirWalker(topDirs, excludeFile);
        new Thread(dirWalker).start();
        return dirWalker;
    }

    public boolean walkComplete() {
        return this.complete;
    }

    public int getFilesCount() {
        return this.files;
    }
}

