/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class SystemPropertiesReader {
    private Logger log = LoggerFactory.getLogger(SystemPropertiesReader.class);

    public SystemPropertiesReader(Collection<Resource> resources) {
        Properties systemProperties = System.getProperties();
        for (Resource resource : resources) {
            try {
                InputStream inputStream = resource.getInputStream();
                Throwable throwable = null;
                try {
                    systemProperties.load(inputStream);
                    this.log.info("loaded {}", (Object)resource.getFile().getAbsolutePath());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception ex) {
                try {
                    this.log.warn("unable to load resource: {}", (Object)resource.getFile().getAbsolutePath());
                }
                catch (Exception exception) {}
            }
        }
    }
}

