/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client.util;

import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.model.Credential;
import org.duracloud.error.ContentStoreException;

public class StoreClientUtil {
    public ContentStore createContentStore(String host, int port, String context, String username, String password, String storeId) {
        ContentStore contentStore;
        ContentStoreManagerImpl storeManager = new ContentStoreManagerImpl(host, String.valueOf(port), context);
        storeManager.login(new Credential(username, password));
        try {
            contentStore = storeId != null ? storeManager.getContentStore(storeId) : storeManager.getPrimaryContentStore();
        }
        catch (ContentStoreException e) {
            String prefix = "Could not create connection to DuraCloud (" + host + ":" + port + "/" + context + "). Cause: ";
            if (e.getMessage().contains("Response code was 401")) {
                throw new RuntimeException(prefix + "invalid credentials. " + "Check your username and password and try again.");
            }
            throw new RuntimeException(prefix + e.getMessage(), e);
        }
        return contentStore;
    }
}

