/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.mgmt;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.duracloud.common.util.DateUtil;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.SyncSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusManager {
    private Logger log = LoggerFactory.getLogger(StatusManager.class);
    private long inWork;
    private long succeeded;
    private List<SyncSummary> failed;
    private List<SyncSummary> recentlyCompleted;
    private String startTime;
    private ChangedList changedList;
    private String version;
    private static StatusManager instance;

    public static StatusManager getInstance() {
        if (instance == null) {
            instance = new StatusManager();
        }
        return instance;
    }

    protected StatusManager() {
        this.init();
    }

    private void init() {
        this.succeeded = 0L;
        this.failed = new ArrayList<SyncSummary>();
        this.startTime = DateUtil.nowLong();
        this.changedList = ChangedList.getInstance();
        this.recentlyCompleted = new LinkedList<SyncSummary>();
    }

    public int getQueueSize() {
        return this.changedList.getListSize();
    }

    public synchronized void startingWork() {
        ++this.inWork;
    }

    public synchronized void stoppingWork() {
        --this.inWork;
    }

    public synchronized void successfulCompletion(SyncSummary summary) {
        ++this.succeeded;
        --this.inWork;
        this.recentlyCompleted.add(0, summary);
        while (this.recentlyCompleted.size() > 100) {
            this.recentlyCompleted.remove(this.recentlyCompleted.size() - 1);
        }
    }

    public synchronized void failedCompletion(SyncSummary file) {
        this.failed.add(file);
        --this.inWork;
    }

    public long getInWork() {
        return this.inWork;
    }

    public long getSucceeded() {
        return this.succeeded;
    }

    public List<SyncSummary> getFailed() {
        return this.failed;
    }

    public List<SyncSummary> getRecentlyCompleted() {
        return new ArrayList<SyncSummary>(this.recentlyCompleted);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void clearFailed() {
        this.log.info("clearing failed list");
        if (this.failed != null) {
            this.failed.clear();
        }
    }

    public void clear() {
        this.init();
    }

    public String getPrintableStatus() {
        StringBuilder status = new StringBuilder();
        status.append("\n-------------------------------------------\n");
        status.append(" Sync Tool " + this.version + " - Status");
        status.append("\n-------------------------------------------\n");
        status.append("Start Time: " + this.startTime + "\n");
        status.append("Current Time: " + DateUtil.nowVerbose() + "\n");
        status.append("Sync Queue Size: " + this.getQueueSize() + "\n");
        status.append("Syncs In Process: " + this.getInWork() + "\n");
        status.append("Successful Syncs: " + this.getSucceeded() + "\n");
        status.append("Failed Syncs: " + this.getFailed().size() + "\n");
        for (SyncSummary failedFile : this.getFailed()) {
            status.append("  " + failedFile.getAbsolutePath() + "\n");
        }
        status.append("-------------------------------------------\n");
        return status.toString();
    }
}

