/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.model;

import org.duracloud.common.model.Credential;
import org.duracloud.common.util.ChecksumUtil;

public class RootUserCredential
extends Credential {
    private static final String defaultUsernameProp = "root.username";
    private static final String defaultPasswordProp = "root.password";
    private static final String defaultEmailProp = "root.email";
    private static String usernameProp = "root.username";
    private static String passwordProp = "root.password";
    private static String emailProp = "root.email";
    private static final String defaultUsername = "root";
    private static final String defaultPassword = "rpw";
    private static final String defaultEmail = "no-root-password-set";

    public RootUserCredential() {
        super(RootUserCredential.getRootUsername(), RootUserCredential.getRootPassword());
    }

    public static void overrideSystemPropertyKeys(String usernameProp, String passwordProp, String emailProp) {
        RootUserCredential.usernameProp = RootUserCredential.userDefaultIfNull(usernameProp, defaultUsernameProp);
        RootUserCredential.passwordProp = RootUserCredential.userDefaultIfNull(passwordProp, defaultPasswordProp);
        RootUserCredential.emailProp = RootUserCredential.userDefaultIfNull(emailProp, defaultEmailProp);
    }

    private static String userDefaultIfNull(String prop, String defaultProp) {
        return prop != null ? prop : defaultProp;
    }

    public static String getRootUsername() {
        return RootUserCredential.getProperty(usernameProp, defaultUsername);
    }

    public static String getRootEmail() {
        return RootUserCredential.getProperty(emailProp, defaultEmail);
    }

    private static String getRootPassword() {
        return RootUserCredential.getProperty(passwordProp, defaultPassword);
    }

    private static String getProperty(String propertyKey, String defaultValue) {
        return System.getProperty(propertyKey, defaultValue);
    }

    public String getRootEncodedPassword() {
        ChecksumUtil util = new ChecksumUtil(ChecksumUtil.Algorithm.SHA_256);
        return util.generateChecksum(RootUserCredential.getRootPassword());
    }
}

