/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.error;

import java.util.List;
import org.duracloud.common.error.DuraCloudCheckedException;

public class ManifestVerifyException
extends DuraCloudCheckedException {
    private ErrorType errorType;

    public ManifestVerifyException(String msg) {
        super(msg);
        this.errorType = ErrorType.INVALID;
        this.setArgs(msg);
    }

    public ManifestVerifyException(String file0, String file1, int count0, int count1) {
        this.errorType = ErrorType.UNEQUAL_NUM_ENTRIES;
        this.setArgs(file0, file1, Integer.toString(count0), Integer.toString(count1));
    }

    public ManifestVerifyException(String file0, String file1, List<String> badChksumPairs) {
        this.errorType = ErrorType.CHKSUM_MISMATCH;
        StringBuilder sb = new StringBuilder();
        for (String pair : badChksumPairs) {
            sb.append(pair);
            sb.append("\n");
        }
        this.setArgs(file0, file1, sb.toString());
    }

    @Override
    public String getKey() {
        return this.errorType.getKey();
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public static enum ErrorType {
        UNEQUAL_NUM_ENTRIES("duracloud.error.manifest.unequal"),
        CHKSUM_MISMATCH("duracloud.error.manifest.chksum"),
        INVALID("duracloud.error.manifest.invalid");

        private String key;

        private ErrorType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

