/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.CharacterSet;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CharacterSetStaxUnmarshaller
implements Unmarshaller<CharacterSet, StaxUnmarshallerContext> {
    private static CharacterSetStaxUnmarshaller instance;

    @Override
    public CharacterSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        CharacterSet characterSet = new CharacterSet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return characterSet;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CharacterSetName", targetDepth)) {
                    characterSet.setCharacterSetName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CharacterSetDescription", targetDepth)) continue;
                characterSet.setCharacterSetDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return characterSet;
    }

    public static CharacterSetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CharacterSetStaxUnmarshaller();
        }
        return instance;
    }
}

