/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.DBCluster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeDBClustersResult
implements Serializable,
Cloneable {
    private String marker;
    private ListWithAutoConstructFlag<DBCluster> dBClusters;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeDBClustersResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<DBCluster> getDBClusters() {
        if (this.dBClusters == null) {
            this.dBClusters = new ListWithAutoConstructFlag();
            this.dBClusters.setAutoConstruct(true);
        }
        return this.dBClusters;
    }

    public void setDBClusters(Collection<DBCluster> dBClusters) {
        if (dBClusters == null) {
            this.dBClusters = null;
            return;
        }
        ListWithAutoConstructFlag dBClustersCopy = new ListWithAutoConstructFlag(dBClusters.size());
        dBClustersCopy.addAll(dBClusters);
        this.dBClusters = dBClustersCopy;
    }

    public DescribeDBClustersResult withDBClusters(DBCluster ... dBClusters) {
        if (this.getDBClusters() == null) {
            this.setDBClusters(new ArrayList<DBCluster>(dBClusters.length));
        }
        for (DBCluster value : dBClusters) {
            this.getDBClusters().add(value);
        }
        return this;
    }

    public DescribeDBClustersResult withDBClusters(Collection<DBCluster> dBClusters) {
        if (dBClusters == null) {
            this.dBClusters = null;
        } else {
            ListWithAutoConstructFlag dBClustersCopy = new ListWithAutoConstructFlag(dBClusters.size());
            dBClustersCopy.addAll(dBClusters);
            this.dBClusters = dBClustersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getDBClusters() != null) {
            sb.append("DBClusters: " + this.getDBClusters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusters() == null ? 0 : this.getDBClusters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBClustersResult)) {
            return false;
        }
        DescribeDBClustersResult other = (DescribeDBClustersResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getDBClusters() == null ^ this.getDBClusters() == null) {
            return false;
        }
        return other.getDBClusters() == null || other.getDBClusters().equals(this.getDBClusters());
    }

    public DescribeDBClustersResult clone() {
        try {
            return (DescribeDBClustersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

