/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ConfigurationJsonMarshaller {
    private static ConfigurationJsonMarshaller instance;

    public void marshall(Configuration configuration, JSONWriter jsonWriter) {
        if (configuration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            ListWithAutoConstructFlag configurationsList;
            jsonWriter.object();
            if (configuration.getClassification() != null) {
                jsonWriter.key("Classification").value(configuration.getClassification());
            }
            if (!((configurationsList = (ListWithAutoConstructFlag)configuration.getConfigurations()) == null || configurationsList.isAutoConstruct() && configurationsList.isEmpty())) {
                jsonWriter.key("Configurations");
                jsonWriter.array();
                for (Configuration configuration2 : configurationsList) {
                    if (configuration2 == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configuration2, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (configuration.getProperties() != null) {
                jsonWriter.key("Properties");
                jsonWriter.object();
                for (Map.Entry entry : configuration.getProperties().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key((String)entry.getKey());
                    jsonWriter.value(entry.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigurationJsonMarshaller();
        }
        return instance;
    }
}

