/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.S3Location;
import com.amazonaws.util.json.JSONWriter;

public class S3LocationJsonMarshaller {
    private static S3LocationJsonMarshaller instance;

    public void marshall(S3Location s3Location, JSONWriter jsonWriter) {
        if (s3Location == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (s3Location.getBucket() != null) {
                jsonWriter.key("bucket").value(s3Location.getBucket());
            }
            if (s3Location.getKey() != null) {
                jsonWriter.key("key").value(s3Location.getKey());
            }
            if (s3Location.getBundleType() != null) {
                jsonWriter.key("bundleType").value(s3Location.getBundleType());
            }
            if (s3Location.getVersion() != null) {
                jsonWriter.key("version").value(s3Location.getVersion());
            }
            if (s3Location.getETag() != null) {
                jsonWriter.key("eTag").value(s3Location.getETag());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3LocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3LocationJsonMarshaller();
        }
        return instance;
    }
}

