/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class BatchGetOnPremisesInstancesRequestMarshaller
implements Marshaller<Request<BatchGetOnPremisesInstancesRequest>, BatchGetOnPremisesInstancesRequest> {
    @Override
    public Request<BatchGetOnPremisesInstancesRequest> marshall(BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) {
        if (batchGetOnPremisesInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetOnPremisesInstancesRequest> request = new DefaultRequest<BatchGetOnPremisesInstancesRequest>(batchGetOnPremisesInstancesRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.BatchGetOnPremisesInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            SdkInternalList instanceNamesList = (SdkInternalList)batchGetOnPremisesInstancesRequest.getInstanceNames();
            if (!instanceNamesList.isEmpty() || !instanceNamesList.isAutoConstruct()) {
                jsonWriter.key("instanceNames");
                jsonWriter.array();
                for (String instanceNamesListValue : instanceNamesList) {
                    if (instanceNamesListValue == null) continue;
                    jsonWriter.value(instanceNamesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

