/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncExecutor;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicy;
import java.util.Date;
import java.util.concurrent.CancellationException;

public class AsyncRetryingExecutor
implements AsyncExecutor {
    private final RetryPolicy retryPolicy;
    private WorkflowClock clock;

    public AsyncRetryingExecutor(RetryPolicy retryPolicy, WorkflowClock clock) {
        this.retryPolicy = retryPolicy;
        this.clock = clock;
    }

    @Override
    public void execute(AsyncRunnable command) throws Throwable {
        this.scheduleWithRetry(command, null, 1, this.clock.currentTimeMillis(), 0L);
    }

    private void scheduleWithRetry(final AsyncRunnable command, Throwable failure, final int attempt, final long firstAttemptTime, long timeOfRecordedFailure) throws Throwable {
        long delay = -1L;
        if (attempt > 1) {
            if (!this.retryPolicy.isRetryable(failure)) {
                throw failure;
            }
            delay = this.retryPolicy.nextRetryDelaySeconds(new Date(firstAttemptTime), new Date(timeOfRecordedFailure), attempt);
            if (delay < 0L) {
                throw failure;
            }
        }
        if (delay > 0L) {
            Promise<Void> timer = this.clock.createTimer(delay);
            new Task(new Promise[]{timer}){

                @Override
                protected void doExecute() throws Throwable {
                    AsyncRetryingExecutor.this.invoke(command, attempt, firstAttemptTime);
                }
            };
        } else {
            this.invoke(command, attempt, firstAttemptTime);
        }
    }

    private void invoke(final AsyncRunnable command, final int attempt, final long firstAttemptTime) {
        final Settable shouldRetry = new Settable();
        new TryCatchFinally(){
            Throwable failureToRetry = null;

            @Override
            protected void doTry() throws Throwable {
                command.run();
            }

            @Override
            protected void doCatch(Throwable failure) throws Throwable {
                if (failure instanceof CancellationException) {
                    throw failure;
                }
                this.failureToRetry = failure;
            }

            @Override
            protected void doFinally() throws Throwable {
                shouldRetry.set(this.failureToRetry);
            }
        };
        new Task(new Promise[]{shouldRetry}){

            @Override
            protected void doExecute() throws Throwable {
                Throwable failure = (Throwable)shouldRetry.get();
                if (failure != null) {
                    AsyncRetryingExecutor.this.scheduleWithRetry(command, failure, attempt + 1, firstAttemptTime, AsyncRetryingExecutor.this.clock.currentTimeMillis());
                }
            }
        };
    }
}

