/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.importexport.model.UpdateJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateJobRequestMarshaller
implements Marshaller<Request<UpdateJobRequest>, UpdateJobRequest> {
    @Override
    public Request<UpdateJobRequest> marshall(UpdateJobRequest updateJobRequest) {
        if (updateJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateJobRequest> request = new DefaultRequest<UpdateJobRequest>(updateJobRequest, "AmazonImportExport");
        request.addParameter("Action", "UpdateJob");
        request.addParameter("Version", "2010-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateJobRequest.getJobId() != null) {
            request.addParameter("JobId", StringUtils.fromString(updateJobRequest.getJobId()));
        }
        if (updateJobRequest.getManifest() != null) {
            request.addParameter("Manifest", StringUtils.fromString(updateJobRequest.getManifest()));
        }
        if (updateJobRequest.getJobType() != null) {
            request.addParameter("JobType", StringUtils.fromString(updateJobRequest.getJobType()));
        }
        if (updateJobRequest.getValidateOnly() != null) {
            request.addParameter("ValidateOnly", StringUtils.fromBoolean(updateJobRequest.getValidateOnly()));
        }
        if (updateJobRequest.getAPIVersion() != null) {
            request.addParameter("APIVersion", StringUtils.fromString(updateJobRequest.getAPIVersion()));
        }
        return request;
    }
}

