/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.VaultAccessPolicy;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SetVaultAccessPolicyRequestMarshaller
implements Marshaller<Request<SetVaultAccessPolicyRequest>, SetVaultAccessPolicyRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<SetVaultAccessPolicyRequest> marshall(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) {
        String value;
        String name;
        if (setVaultAccessPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetVaultAccessPolicyRequest> request = new DefaultRequest<SetVaultAccessPolicyRequest>(setVaultAccessPolicyRequest, "AmazonGlacier");
        String target = "Glacier.SetVaultAccessPolicy";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string = value = setVaultAccessPolicyRequest.getAccountId() == null ? null : StringUtils.fromString(setVaultAccessPolicyRequest.getAccountId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", setVaultAccessPolicyRequest.getAccountId() == null ? "" : StringUtils.fromString(setVaultAccessPolicyRequest.getAccountId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("vaultName")) {
            name = DYNAMIC_QUERY_PARAMS.get("vaultName");
            String string = value = setVaultAccessPolicyRequest.getVaultName() == null ? null : StringUtils.fromString(setVaultAccessPolicyRequest.getVaultName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{vaultName}", setVaultAccessPolicyRequest.getVaultName() == null ? "" : StringUtils.fromString(setVaultAccessPolicyRequest.getVaultName()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            VaultAccessPolicy policy = setVaultAccessPolicyRequest.getPolicy();
            if (policy != null) {
                jsonWriter.object();
                if (policy.getPolicy() != null) {
                    jsonWriter.key("Policy").value(policy.getPolicy());
                }
                jsonWriter.endObject();
            }
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/{accountId}/vaults/{vaultName}/access-policy";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

